# Recreating BULLETIN

Back in university we used to use a system called BULLETIN on the
local VAX/VMS cluster.  It eventually went away due to security issues.
But I was thinking it might be fun to recreate.  First though I'd like
an historic git repo that covers the early years.

This repository contains the following main branches:

  * `release`    - A recreation of BULLETIN written in Go and designed
    to run under a single Unix user.                        84ff1ce
  * `conversion` - Multiple versions of the original source code.

The bulletin binary is designed to be run via the ssh command option for
an authorised key.  That will specify the user. This means that bulletin
will initialise itself with that user for that session.

The code is organised like so:

  * `ask`       - Contains routines for asking the user questions.
  * `batch`     - Contains the batch routines - the `-b` flag.
  * `dclish`    - A command line parser akin to DCL.
  * `decus`     - Historical version this version is based on.
  * `editor`    - An editor function.
  * `folders`   - A higher level version of `storage` routines.
  * `key`       - Routines for handling ssh keys.
  * `pager`     - A pager function.
  * `repl`      - Actions and commands for the REPL.
  * `storage`   - Lower level storage routines.
  * `this`      - The current session.
  * `users`     - Validation routines for users.

# History of BULLETIN

First, git commits need an author.  It would be nice to figure out
the author.  The version I used I suspect was written by
[Mark London](http://web.mit.edu/london/www/home.html). There were
contributions by others. I'll attempt to track those as much as I can.

Releases back then did not have commit messages or changelogs. However
there do seem to have been some announcements and the code does note
some of the contributors.

## Where to find historical BULLETIN releases

The place to get it seems to be the [DECUS archives](http://decuslib.com/).
I tracked it down with help from Kent Brodie who I discovered via
[an old USENET post](https://groups.google.com/forum/#!search/bulletin$20vms/comp.os.vms/rzM2LQMl6Jo/y1BKhO7dv80J)
where he too was trying to track the software down. In 1994.

