package batch

import (
	"fmt"
	"os"
	"os/exec"
	"strings"
)

func touch(name string) error {
	f, err := os.OpenFile(name, os.O_RDONLY|os.O_CREATE, 0666)
	if err != nil {
		return err
	}
	f.Close()
	return nil
}

func installCrontab(crontab string) error {
	// Make a temp file.
	f, err := os.CreateTemp("", "crontab")
	if err != nil {
		return err
	}
	defer func() {
		f.Close()
		os.Remove(f.Name())
	}()

	// Put the crontab in the temp file.
	n, err := f.WriteString(crontab)
	if err != nil {
		return err
	}
	if n != len(crontab) {
		return fmt.Errorf("Failed to write crontab fully %d of %d chars written",
			n, len(crontab))
	}

	// Have the crontab command read in the file.
	cmd := exec.Command("crontab", f.Name())
	cmd.Stdin = strings.NewReader("")
	var stdout strings.Builder
	cmd.Stdout = &stdout
	var stderr strings.Builder
	cmd.Stderr = &stdout
	err = cmd.Run()
	if err != nil {
		fmt.Printf("ERROR: stdout: [%s]\n", stdout.String())
		fmt.Printf("ERROR: stderr: [%s]\n", stderr.String())
		return err
	}

	return nil
}
