$set nover
$copy/log sys$input BOARD_DIGEST.COM
$deck
$!
$! BOARD_DIGEST.COM
$!
$! Command file invoked by folder associated with a BBOARD which is
$! is specified with /SPECIAL.  It will convert "digest" mail and
$! split it into separate messages.  This type of mail is used in
$! certain Arpanet mailing lists, such as TEXHAX and INFO-MAC.
$!
$ FF[0,8] = 12			! Define a form feed character
$ SET PROTECT=(W:RWED)/DEFAULT
$ SET PROC/PRIV=SYSPRV
$ USER := 'F$GETJPI("","USERNAME")
$ EXTRACT_FILE = "BULL_DIR:" + "''USER'" + ".TXT"
$ DEFINE/USER EXTRACT_FILE BULL_DIR:'USER'
$ MAIL
READ
EXTRACT EXTRACT_FILE
DELETE
$ OPEN/READ INPUT 'EXTRACT_FILE'
$ OPEN/WRITE OUTPUT 'EXTRACT_FILE'
$ READ INPUT FROM_USER
$AGAIN:
$ READ/END=ERROR INPUT BUFFER
$ IF F$EXTRACT(0,3,BUFFER) .NES. "To:" THEN GOTO SKIP
$ USER = F$EXTRACT(4,F$LEN(BUFFER),BUFFER)
$ GOTO AGAIN1
$SKIP:
$ IF F$EXTRACT(0,15,BUFFER) .NES. "---------------" THEN GOTO AGAIN
$AGAIN1:
$ READ/END=ERROR INPUT BUFFER
$ IF F$EXTRACT(0,15,BUFFER) .NES. "---------------" THEN GOTO AGAIN1
$ FROM = " "
$ SUBJ = " "
$NEXT:
$ READ/END=EXIT INPUT BUFFER
$FROM:
$ IF F$EXTRACT(0,5,BUFFER) .NES. "From:" THEN GOTO SUBJECT
$ FROM = BUFFER 
$ GOTO NEXT
$SUBJECT:
$ IF F$EXTRACT(0,8,BUFFER) .NES. "Subject:" THEN GOTO NEXT
$ SUBJ = BUFFER - "Subject:"
$F2:
$ IF F$LENGTH(SUBJ) .EQ. 0 THEN GOTO WRITE
$ IF F$EXTRACT(0,1,SUBJ) .NES. " " THEN GOTO WRITE
$ SUBJ = F$EXTRACT(1,F$LENGTH(SUBJ),SUBJ)
$ GOTO F2
$WRITE:
$ WRITE OUTPUT FROM_USER
				! Write From: + TAB + USERNAME
$ WRITE OUTPUT "To:	" + USER
				! Write To: + TAB + BBOARDUSERNAME
$ WRITE OUTPUT "Subj:	" + SUBJ
				! Write Subject: + TAB + mail subject
$ WRITE OUTPUT ""		! Write one blank line
$ IF FROM .NES. " " THEN WRITE OUTPUT FROM
$READ:
$ READ/END=EXIT/ERR=EXIT INPUT BUFFER
$ IF F$EXTRACT(0,15,BUFFER) .EQS. "---------------" THEN GOTO READ1
$ WRITE OUTPUT BUFFER
$ GOTO READ
$READ1:
$ READ/END=EXIT/ERR=EXIT INPUT BUFFER
$ IF F$LOCATE(":",BUFFER) .EQ. F$LENGTH(BUFFER) THEN GOTO READ1
$ WRITE OUTPUT FF
$ FROM = " "
$ SUBJ = " "
$ GOTO FROM
$EXIT:
$ CLOSE INPUT
$ CLOSE OUTPUT
$ PUR 'EXTRACT_FILE'
$ EXIT
$ERROR:
$ CLOSE INPUT
$ CLOSE OUTPUT
$ DELETE 'EXTRACT_FILE';
$eod 
$copy/log sys$input BOARD_SPECIAL.COM
$deck
$!
$! BOARD_SPECIAL.COM
$!
$! Command file invoked by folder associated with a BBOARD which is
$! is specified with /SPECIAL.  This can be used to convert data to
$! a message via a different means than the VMS mail.  This is done by
$! converting the data to look like output created by the MAIL utility,
$! which appears as follows:
$!
$!	First line is 0 length line.
$!	Second line is "From:" followed by TAB followed by incoming username
$!	Third line is "To:" followed by TAB followed by BBOARD username
$!	Fourth line is "Subj:" followed by TAB followed by subject
$!	The message text then follows.
$!	Message is ended by a line containing a FORM FEED.
$!
$! This command file should be put in the BBOARD_DIRECTORY as specified
$! in BULLFILES.INC.  You can also have several different types of special
$! procedures.  To accomplish this, rename the file to the BBOARD username.
$! i.e. if you specify SET BBOARD FOO/SPECIAL, you could name the file
$! FOO.COM and it will execute that rather than BOARD_SPECIAL.COM.
$!
$! The following routine is the one we use to convert mail from a non-DEC
$! mail network.  The output from this mail is written into a file which
$! is slightly different from the type outputted by MAIL.
$!
$! (NOTE: A username in the SET BBOARD command need only be specified if
$! the process which reads the mail requires that the process be owned by
$! a specific user, which is the case for this sample, and for that matter
$! when reading VMS MAIL.  If this is not required, you do not have to
$! specify a username.)
$!
$ USERNAME := 'F$GETJPI("","USERNAME")'		! This trims trailing spaces
$ IF F$SEARCH("MFE_TELL_FILES:"+USERNAME+".MAI") .EQS. "" THEN EXIT
$ SET DEFAULT BULL_DIR:	! BULLETIN looks for text in BBOARD directory
$ SET PROTECT=(W:RWED)/DEFAULT
$ IF F$SEARCH("MFEMSG.MAI") .NES. "" THEN -
  DELETE MFEMSG.MAI;*		! Delete any leftover output files.
$ MSG := $MFE_TELL: MESSAGE
$ DEFINE/USER SYS$COMMAND SYS$INPUT
$ MSG				! Read MFENET mail
copy * MFEMSG
delete *
exit
$ FF[0,8] = 12			! Define a form feed character
$ OPEN/READ/ERROR=EXIT INPUT MFEMSG.MAI
$ OUTNAME = USERNAME+".TXT"	! Output file will be 'USERNAME'.TXT
$ OPEN/WRITE OUTPUT 'OUTNAME'
$ READ/END=END INPUT DATA		! Skip first line in MSG output
$HEADER:
$ FROM = ""
$ SUBJ = ""
$ MFEMAIL = "T"
$NEXTHEADER:
$ IF (FROM.NES."") .AND. (SUBJ.NES."") THEN GOTO SKIPHEADER
$ READ/END=END INPUT DATA		! Read header line in MSG output
$ IF DATA .EQS. "" THEN GOTO SKIPHEADER	! Missing From or Subj ??
$ IF FROM .NES. "" THEN GOTO SKIPFROM
$ IF F$LOCATE("From: ",DATA) .NES. 0 THEN GOTO 10$
$ MFEMAIL = "F"
$ FROM= F$EXTRACT(6,F$LENGTH(DATA),DATA)
$ GOTO NEXTHEADER
$10$:
$ IF F$LOCATE("Reply-to: ",DATA) .NES. 0 THEN GOTO 20$
$ MFEMAIL = "F"
$ FROM= F$EXTRACT(10,F$LENGTH(DATA),DATA)
$ GOTO NEXTHEADER
$20$:
$ IF F$LOCATE("From ",DATA) .NES. 0 THEN GOTO SKIPFROM
$ FROM= F$EXTRACT(5,F$LENGTH(DATA),DATA)
$ GOTO NEXTHEADER
$SKIPFROM:
$ IF SUBJ .NES. "" THEN GOTO SKIPSUBJ
$ IF F$LOCATE("Subject",DATA) .NES. 0 THEN GOTO SKIPSUBJ
$ SUBJ= F$EXTRACT(F$LOCATE(": ",DATA)+2,F$LENGTH(DATA),DATA)
$ GOTO NEXTHEADER
$SKIPSUBJ:
$ GOTO NEXTHEADER
$SKIPHEADER:
$ WRITE OUTPUT "From:	" + FROM
				! Write From: + TAB + USERNAME
$ WRITE OUTPUT "To:	" + USERNAME
				! Write To: + TAB + BBOARDUSERNAME
$ WRITE OUTPUT "Subj:	" + SUBJ
				! Write Subject: + TAB + mail subject
$ WRITE OUTPUT ""		! Write one blank line
$ IF (DATA.EQS."") .OR. MFEMAIL THEN GOTO SKIPBLANKS
$50$:
$ READ/END=END INPUT DATA		! Skip rest of main header
$ IF DATA .NES. "" THEN GOTO 50$
$60$:
$ READ/END=END INPUT DATA		! Skip all of secondary header
$ IF DATA .NES. "" THEN GOTO 60$
$SKIPBLANKS:
$ READ/END=END INPUT DATA		! Skip all blanks
$ IF DATA .EQS. "" THEN GOTO SKIPBLANKS
$NEXT:				! Read and write message text
$ WRITE OUTPUT DATA
$ IF DATA .EQS. FF THEN GOTO HEADER
			! Multiple messages are seperated by form feeds
$ READ/END=END INPUT DATA
$ GOTO NEXT
$END:
$ CLOSE INPUT
$ CLOSE OUTPUT
$ DELETE MFEMSG.MAI;
$EXIT:
$ EXIT
$eod 
$copy/log sys$input BULLCOM.CLD
$deck
!
! BULLCOM.CLD
!
! VERSION 10/21/91
!
 	MODULE BULLETIN_SUBCOMMANDS
 
	DEFINE VERB ADD
		PARAMETER P1, LABEL=FILESPEC, VALUE(TYPE=$FILE)
		QUALIFIER ALL, NONNEGATABLE
		QUALIFIER BELL, NONNEGATABLE
		QUALIFIER BROADCAST, NONNEGATABLE
		DISALLOW NOT BROADCAST AND ALL
		DISALLOW NOT BROADCAST AND BELL
		QUALIFIER CC, VALUE(LIST,REQUIRED)
		QUALIFIER CLUSTER, DEFAULT
		QUALIFIER EDIT, NEGATABLE
		QUALIFIER EXPIRATION, NONNEGATABLE, VALUE
		QUALIFIER EXTRACT, NONNEGATABLE
		QUALIFIER FOLDER, LABEL=SELECT_FOLDER, VALUE(REQUIRED,LIST)
		QUALIFIER GROUPS, VALUE(LIST,REQUIRED)
		QUALIFIER NODES, LABEL=NODES, VALUE(REQUIRED,LIST)
		NONNEGATABLE
		QUALIFIER LIST,DEFAULT
		QUALIFIER LOCAL, NONNEGATABLE
		DISALLOW LOCAL AND NOT BROADCAST
		DISALLOW NODES AND SELECT_FOLDER
		QUALIFIER NOINDENT, NONNEGATABLE
		DISALLOW NOINDENT AND NOT EXTRACT
		QUALIFIER PERMANENT, NONNEGATABLE
		QUALIFIER SHUTDOWN, NONNEGATABLE, VALUE
		DISALLOW PERMANENT AND SHUTDOWN
		QUALIFIER NOSIGNATURE
		QUALIFIER SUBJECT, NONNEGATABLE, VALUE(REQUIRED)
		QUALIFIER SYSTEM, NONNEGATABLE
	DEFINE VERB ATTACH
		PARAMETER P1, LABEL=PROCESS, VALUE(TYPE=$FILE)
		QUALIFIER PARENT
		DISALLOW NOT PARENT AND NOT PROCESS
		DISALLOW PARENT AND PROCESS
	DEFINE VERB BACK
		QUALIFIER EDIT, NEGATABLE
		QUALIFIER HEADER
	DEFINE VERB CHANGE
		PARAMETER P1, LABEL=FILESPEC, VALUE(TYPE=$FILE)
		QUALIFIER ALL
		QUALIFIER EDIT, NEGATABLE
		QUALIFIER EXPIRATION, NONNEGATABLE, VALUE
		QUALIFIER GENERAL, NONNEGATABLE
		QUALIFIER HEADER, NONNEGATABLE
		QUALIFIER SUBJECT, NONNEGATABLE, VALUE(REQUIRED)
		QUALIFIER NEW,NONNEGATABLE
		QUALIFIER NUMBER, VALUE(TYPE=$FILE,REQUIRED)
		QUALIFIER PERMANENT, NONNEGATABLE
		QUALIFIER SHUTDOWN, NONNEGATABLE, VALUE
		QUALIFIER SYSTEM,NONNEGATABLE
		QUALIFIER TEXT, NONNEGATABLE
		DISALLOW ALL AND NUMBER
		DISALLOW NEW AND NOT EDIT
		DISALLOW SYSTEM AND GENERAL
		DISALLOW PERMANENT AND SHUTDOWN
		DISALLOW PERMANENT AND EXPIRATION
		DISALLOW SHUTDOWN AND EXPIRATION
		DISALLOW SUBJECT AND HEADER
	DEFINE VERB COPY
		PARAMETER P1, LABEL=FOLDER, PROMPT="Folder"
			VALUE(REQUIRED)
		PARAMETER P2, LABEL=BULLETIN_NUMBER, VALUE(TYPE=$FILE)
		QUALIFIER GROUPS, VALUE(LIST,REQUIRED)
		QUALIFIER HEADER
		QUALIFIER ALL
		QUALIFIER MERGE
		QUALIFIER ORIGINAL
		DISALLOW ALL AND BULLETIN_NUMBER
	DEFINE VERB CREATE
		QUALIFIER ALWAYS, NONNEGATABLE
		QUALIFIER BRIEF, NONNEGATABLE
		QUALIFIER DESCRIPTION, NONNEGATABLE, VALUE(REQUIRED)
		QUALIFIER EDIT, NEGATABLE
		QUALIFIER ID, NONNEGATABLE
!
! Make the following qualifier DEFAULT if you want CREATE to be
! a privileged command.  NOTE: Make sure that BULL_DIR:BULLUSER.DAT
! has the following protection:  (RWED,RWED,,)
!
		QUALIFIER NEEDPRIV, NONNEGATABLE
		QUALIFIER NEWS
		QUALIFIER NODE, NONNEGATABLE, VALUE(REQUIRED)
		QUALIFIER NOTIFY, NONNEGATABLE
		QUALIFIER OWNER, NONNEGATABLE, VALUE(REQUIRED)
		QUALIFIER PRIVATE, NONNEGATABLE
		QUALIFIER READNEW, NONNEGATABLE
		QUALIFIER REMOTENAME, NONNEGATABLE, VALUE(REQUIRED)
		QUALIFIER SEMIPRIVATE, NONNEGATABLE
		QUALIFIER SHOWNEW, NONNEGATABLE
		QUALIFIER SYSTEM, NONNEGATABLE
		PARAMETER P1, LABEL=CREATE_FOLDER, PROMPT="Folder"
			VALUE(REQUIRED)
		PARAMETER P2, LABEL=FILESPEC, VALUE(TYPE=$FILE)
		DISALLOW ID AND NOT OWNER
		DISALLOW PRIVATE AND SEMIPRIVATE
		DISALLOW BRIEF AND READNEW
		DISALLOW SHOWNEW AND READNEW
		DISALLOW BRIEF AND SHOWNEW
		DISALLOW NODE AND (NOTIFY OR PRIVATE OR SEMIPRIVATE)
		DISALLOW REMOTENAME AND NOT NODE
	DEFINE VERB CURRENT
		QUALIFIER EDIT
		QUALIFIER HEADER
	DEFINE VERB DELETE
		PARAMETER P1, LABEL=BULLETIN_NUMBER, VALUE(TYPE=$FILE)
		QUALIFIER ALL
		QUALIFIER IMMEDIATE,NONNEGATABLE
		QUALIFIER FOLDER, LABEL=SELECT_FOLDER, VALUE(REQUIRED,LIST)
		QUALIFIER NODES, LABEL=NODES, VALUE(REQUIRED,LIST)
		QUALIFIER SUBJECT, VALUE(REQUIRED)
		DISALLOW NOT SUBJECT AND (NODES OR SELECT_FOLDER)
		DISALLOW NODES AND SELECT_FOLDER
	DEFINE VERB DIRECTORY
		PARAMETER P1, LABEL=SELECT_FOLDER
		QUALIFIER ALL
		QUALIFIER NEWS, SYNTAX=DIRECTORY_NEWS, NONNEGATABLE
		QUALIFIER END, VALUE(REQUIRED,TYPE=$NUMBER), NONNEGATABLE
		QUALIFIER EXPIRATION
		QUALIFIER FO, SYNTAX=DIRECTORY_FOLDER, NONNEGATABLE
		QUALIFIER FOLDER, SYNTAX=DIRECTORY_FOLDER, NONNEGATABLE
		QUALIFIER NEW
		QUALIFIER PRINT
		QUALIFIER HEADER, DEFAULT
		QUALIFIER NOTIFY, DEFAULT
		QUALIFIER QUEUE, VALUE(DEFAULT=SYS$PRINT), NONNEGATABLE
                QUALIFIER FORM, VALUE, NONNEGATABLE
		QUALIFIER NOW
		QUALIFIER START, VALUE(REQUIRED,TYPE=$NUMBER), NONNEGATABLE
		QUALIFIER SINCE,VALUE(DEFAULT="TODAY",TYPE=$DATETIME)
		QUALIFIER MARKED, NONNEGATABLE
		QUALIFIER UNMARKED, NONNEGATABLE
		QUALIFIER REPLY, NONNEGATABLE
		QUALIFIER SEARCH, VALUE(REQUIRED), NONNEGATABLE
		QUALIFIER SEEN, NONNEGATABLE
		QUALIFIER UNSEEN, NONNEGATABLE
		QUALIFIER SUBJECT, VALUE(REQUIRED), NONNEGATABLE
		DISALLOW (SUBJECT AND SEARCH) OR (SEARCH AND REPLY)
		DISALLOW REPLY AND SUBJECT
		DISALLOW (REPLY OR SUBJECT OR SEARCH) AND
			 (MARKED OR SEEN OR UNMARKED OR UNSEEN)
		DISALLOW (MARKED AND SEEN) OR (MARKED AND UNSEEN) OR
			 (UNMARKED AND SEEN) OR (UNMARKED AND UNSEEN)
		DISALLOW ALL AND (MARKED OR SEEN OR UNMARKED OR UNSEEN)
		DISALLOW (NEW AND SINCE) OR (START AND NEW) OR (START AND SINCE)
	DEFINE SYNTAX DIRECTORY_NEWS
		PARAMETER P1, LABEL=MATCH_FOLDER
		QUALIFIER START, VALUE(REQUIRED), NONNEGATABLE
		QUALIFIER NEWS, DEFAULT, NONNEGATABLE
		QUALIFIER SUBSCRIBE
		QUALIFIER FOLDER
		QUALIFIER NEWGROUPS
		DISALLOW NEWGROUPS AND (SUBSCRIBE OR START)
	DEFINE SYNTAX DIRECTORY_FOLDER
		PARAMETER P1, LABEL=MATCH_FOLDER
		QUALIFIER START, VALUE(REQUIRED), NONNEGATABLE
		QUALIFIER DESCRIBE
		QUALIFIER FOLDER, DEFAULT
		QUALIFIER NEWS, NONNEGATABLE
	DEFINE VERB E				! EXIT command.
	DEFINE VERB EX				! EXIT command.
	DEFINE VERB EXIT			! EXIT command.
	DEFINE VERB EXTRACT
		PARAMETER P1, LABEL=FILESPEC, VALUE(TYPE=$FILE,REQUIRED),
			PROMPT="File"
		PARAMETER P2, LABEL=BULLETIN_NUMBER, VALUE(TYPE=$FILE,LIST)
		QUALIFIER ALL
		QUALIFIER FF
		QUALIFIER HEADER, DEFAULT
		QUALIFIER NEW, NONNEGATABLE
		DISALLOW ALL AND BULLETIN_NUMBER
	DEFINE VERB FILE
		PARAMETER P1, LABEL=FILESPEC, VALUE(TYPE=$FILE,REQUIRED),
			PROMPT="File"
		PARAMETER P2, LABEL=BULLETIN_NUMBER, VALUE(TYPE=$FILE,LIST)
		QUALIFIER ALL
		QUALIFIER FF
		QUALIFIER HEADER, DEFAULT
		QUALIFIER NEW, NONNEGATABLE
		DISALLOW ALL AND BULLETIN_NUMBER
	DEFINE VERB FIRST
		QUALIFIER EDIT, NEGATABLE
		QUALIFIER HEADER
	DEFINE VERB FORWARD
		PARAMETER P1, LABEL=RECIPIENTS, PROMPT="Recipients"
		VALUE(REQUIRED,IMPCAT,LIST)
		QUALIFIER EDIT, NONNEGATABLE
		QUALIFIER HEADER, DEFAULT
		QUALIFIER SUBJECT, VALUE(REQUIRED)
	DEFINE VERB HELP
		PARAMETER P1, LABEL=HELP_FOLDER, VALUE(TYPE=$REST_OF_LINE)
	DEFINE VERB INDEX
		PARAMETER P1, LABEL=SELECT_FOLDER
		QUALIFIER EXPIRATION
		QUALIFIER MARKED, NONNEGATABLE
		QUALIFIER UNMARKED, NONNEGATABLE
		QUALIFIER FOLDER, SYNTAX=DIRECTORY_FOLDER, NONNEGATABLE
		QUALIFIER NEW
		QUALIFIER REPLY, NONNEGATABLE
		QUALIFIER RESTART
		QUALIFIER SEARCH, VALUE(REQUIRED), NONNEGATABLE
		QUALIFIER SEEN, NONNEGATABLE
		QUALIFIER UNSEEN, NONNEGATABLE
		QUALIFIER SUBSCRIBE
		QUALIFIER SUBJECT, VALUE(REQUIRED), NONNEGATABLE
		QUALIFIER START, VALUE(REQUIRED,TYPE=$NUMBER), NONNEGATABLE
		QUALIFIER SINCE,VALUE(DEFAULT="TODAY",TYPE=$DATETIME)
		DISALLOW (NEW AND SINCE) OR (START AND NEW) OR (START AND SINCE)
		DISALLOW (MARKED AND SEEN) OR (MARKED AND UNSEEN) OR
			 (UNMARKED AND SEEN) OR (UNMARKED AND UNSEEN)
	DEFINE VERB LAST
		QUALIFIER EDIT, NEGATABLE
		QUALIFIER HEADER
	DEFINE VERB MAIL
		PARAMETER P1, LABEL=RECIPIENTS, PROMPT="Recipients"
		VALUE(REQUIRED,IMPCAT,LIST)
		QUALIFIER EDIT, NONNEGATABLE
		QUALIFIER HEADER, DEFAULT
		QUALIFIER SUBJECT, VALUE(REQUIRED)
	DEFINE VERB MARK
		PARAMETER P1, LABEL=NUMBER, VALUE(TYPE=$FILE,LIST)
	DEFINE VERB MODIFY
		QUALIFIER DESCRIPTION
		QUALIFIER ID, NONNEGATABLE
		QUALIFIER NAME, VALUE(REQUIRED)
		QUALIFIER OWNER, VALUE(REQUIRED)
		DISALLOW ID AND NOT OWNER
	DEFINE VERB MOVE
		PARAMETER P1, LABEL=FOLDER, PROMPT="Folder"
			VALUE(REQUIRED)
		PARAMETER P2, LABEL=BULLETIN_NUMBER, VALUE(TYPE=$FILE)
		QUALIFIER ALL
		QUALIFIER GROUPS, VALUE(LIST,REQUIRED)
		QUALIFIER HEADER
		QUALIFIER MERGE
		QUALIFIER NODES
		QUALIFIER ORIGINAL
		QUALIFIER IMMEDIATE,NONNEGATABLE,DEFAULT
		DISALLOW ALL AND BULLETIN_NUMBER
		DISALLOW FOLDER AND NODES
	DEFINE VERB NEWS
		PARAMETER P1, LABEL=MATCH_FOLDER
		QUALIFIER NEWS, DEFAULT, NONNEGATABLE
		QUALIFIER START, VALUE(REQUIRED), NONNEGATABLE
		QUALIFIER SUBSCRIBE
		QUALIFIER NEWGROUPS
		DISALLOW NEWGROUPS AND (SUBSCRIBE OR START)
	DEFINE VERB N
		QUALIFIER EDIT, NEGATABLE
	DEFINE VERB NEXT
		QUALIFIER EDIT, NEGATABLE
	DEFINE VERB POST
		PARAMETER P1, LABEL=FILESPEC, VALUE(TYPE=$FILE)
		QUALIFIER CC, VALUE(LIST,REQUIRED)
		QUALIFIER EDIT
		QUALIFIER EXTRACT
		QUALIFIER GROUPS, VALUE(LIST,REQUIRED)
		QUALIFIER LIST, DEFAULT
		QUALIFIER NOINDENT, NONNEGATABLE
		DISALLOW NOINDENT AND NOT EXTRACT
		QUALIFIER NOSIGNATURE
		QUALIFIER SUBJECT, VALUE(REQUIRED)
	DEFINE VERB PRINT
		PARAMETER P1, LABEL=BULLETIN_NUMBER, VALUE(TYPE=$FILE,LIST)
		QUALIFIER HEADER, DEFAULT
		QUALIFIER NOTIFY, DEFAULT
		QUALIFIER QUEUE, VALUE(DEFAULT=SYS$PRINT), NONNEGATABLE
                QUALIFIER FORM, VALUE, NONNEGATABLE
		QUALIFIER NOW
		QUALIFIER ALL
		DISALLOW ALL AND BULLETIN_NUMBER
	DEFINE VERB QUIT
	DEFINE VERB READ
		PARAMETER P1, LABEL=BULLETIN_NUMBER, VALUE(TYPE=$NUMBER)
		QUALIFIER ALL
		QUALIFIER EDIT
		QUALIFIER HEADER
		QUALIFIER MARKED, NONNEGATABLE
		QUALIFIER UNMARKED, NONNEGATABLE
		QUALIFIER NEW
		QUALIFIER PAGE, DEFAULT
		QUALIFIER SEEN, NONNEGATABLE
		QUALIFIER UNSEEN, NONNEGATABLE
		QUALIFIER SINCE,VALUE(DEFAULT="TODAY",TYPE=$DATETIME)
		DISALLOW NEW AND SINCE
		DISALLOW BULLETIN_NUMBER AND (ALL OR NEW OR SINCE)
		DISALLOW (MARKED AND SEEN) OR (MARKED AND UNSEEN) OR
			 (UNMARKED AND SEEN) OR (UNMARKED AND UNSEEN)
	DEFINE VERB REPLY
		PARAMETER P1, LABEL=FILESPEC, VALUE(TYPE=$FILE)
		QUALIFIER ALL, NONNEGATABLE
		QUALIFIER BELL, NONNEGATABLE
		QUALIFIER BROADCAST, NONNEGATABLE
		DISALLOW NOT BROADCAST AND ALL
		DISALLOW NOT BROADCAST AND BELL
		QUALIFIER CC, VALUE(LIST,REQUIRED)
		QUALIFIER CLUSTER, DEFAULT
		QUALIFIER EDIT, NEGATABLE
		QUALIFIER EXPIRATION, NONNEGATABLE, VALUE
		QUALIFIER EXTRACT, NONNEGATABLE
		QUALIFIER FOLDER, LABEL=SELECT_FOLDER, VALUE(REQUIRED,LIST)
		QUALIFIER GROUPS, VALUE(LIST,REQUIRED)
		QUALIFIER LIST,DEFAULT
		QUALIFIER LOCAL
		QUALIFIER NODES, LABEL=NODES, VALUE(REQUIRED,LIST)
		NONNEGATABLE
		DISALLOW LOCAL AND NOT BROADCAST
		DISALLOW NODES AND SELECT_FOLDER
		QUALIFIER NOINDENT, NONNEGATABLE
		DISALLOW NOINDENT AND NOT EXTRACT
		QUALIFIER NOSIGNATURE
		QUALIFIER PERMANENT, NONNEGATABLE
		QUALIFIER SHUTDOWN, NONNEGATABLE, VALUE
		DISALLOW PERMANENT AND SHUTDOWN
		QUALIFIER SUBJECT, NONNEGATABLE, VALUE(REQUIRED)
		QUALIFIER SYSTEM, NONNEGATABLE
	DEFINE VERB REMOVE
		PARAMETER P1, LABEL=REMOVE_FOLDER, PROMPT="Folder"
			VALUE(REQUIRED)
	DEFINE VERB RESPOND
		PARAMETER P1, LABEL=FILESPEC, VALUE(TYPE=$FILE)
		QUALIFIER CC, VALUE(LIST,REQUIRED)
		QUALIFIER EXTRACT
		QUALIFIER GROUPS, VALUE(LIST,REQUIRED)
		QUALIFIER LIST
		QUALIFIER SUBJECT, VALUE(REQUIRED)
		QUALIFIER NOINDENT, NONNEGATABLE
		DISALLOW NOINDENT AND NOT EXTRACT
		QUALIFIER NOSIGNATURE
		DISALLOW GROUPS AND NOT LIST
		QUALIFIER EDIT
	DEFINE VERB SEARCH
		PARAMETER P1, LABEL=SEARCH_STRING
		QUALIFIER EDIT
		QUALIFIER FOLDER, LABEL=SELECT_FOLDER, VALUE(REQUIRED,LIST)
		QUALIFIER START, VALUE(TYPE=$NUMBER,REQUIRED)
		QUALIFIER REPLY, NONNEGATABLE
		QUALIFIER REVERSE
		QUALIFIER SUBJECT
		DISALLOW SEARCH_STRING AND REPLY
	DEFINE VERB SEEN
		PARAMETER P1, LABEL=NUMBER, VALUE(TYPE=$FILE,LIST)
		QUALIFIER READ
		DISALLOW (NUMBER AND (NEG READ OR READ))
	DEFINE VERB SELECT
		PARAMETER P1, LABEL=SELECT_FOLDER
		QUALIFIER MARKED, NONNEGATABLE
		QUALIFIER UNMARKED, NONNEGATABLE
		QUALIFIER SEEN, NONNEGATABLE
		QUALIFIER UNSEEN, NONNEGATABLE
		DISALLOW (MARKED AND SEEN) OR (MARKED AND UNSEEN) OR
			 (UNMARKED AND SEEN) OR (UNMARKED AND UNSEEN)
	DEFINE VERB SET
		PARAMETER P1, LABEL=SET_PARAM1, PROMPT="What"
			VALUE(REQUIRED, TYPE=SET_OPTIONS)
		QUALIFIER ID
	DEFINE TYPE SET_OPTIONS
		KEYWORD NODE, SYNTAX=SET_NODE
		KEYWORD NONODE, SYNTAX = SET_NONODE
		KEYWORD EXPIRE_LIMIT, SYNTAX=SET_EXPIRE
		KEYWORD NOEXPIRE_LIMIT
		KEYWORD GENERIC, SYNTAX=SET_GENERIC
		KEYWORD NOGENERIC, SYNTAX=SET_GENERIC
		KEYWORD LOGIN, SYNTAX=SET_LOGIN
		KEYWORD NOLOGIN, SYNTAX=SET_LOGIN
		KEYWORD NOBBOARD
		KEYWORD BBOARD, SYNTAX=SET_BBOARD
		KEYWORD NOBRIEF, SYNTAX=SET_NOFLAGS
		KEYWORD BRIEF, SYNTAX=SET_FLAGS
		KEYWORD NOSHOWNEW, SYNTAX=SET_NOFLAGS
		KEYWORD SHOWNEW, SYNTAX=SET_FLAGS
		KEYWORD NOREADNEW, SYNTAX=SET_NOFLAGS
		KEYWORD READNEW, SYNTAX=SET_FLAGS
		KEYWORD ACCESS, SYNTAX=SET_ACCESS
		KEYWORD NOACCESS, SYNTAX=SET_NOACCESS
		KEYWORD FOLDER, SYNTAX=SET_FOLDER
		KEYWORD NOTIFY, SYNTAX=SET_FLAGS
		KEYWORD NONOTIFY, SYNTAX=SET_NOFLAGS
		KEYWORD PRIVILEGES, SYNTAX=SET_PRIVILEGES
		KEYWORD DUMP
		KEYWORD NODUMP
		KEYWORD PAGE
		KEYWORD NOPAGE
		KEYWORD SYSTEM
		KEYWORD NOSYSTEM
		KEYWORD KEYPAD
		KEYWORD NOKEYPAD
		KEYWORD PROMPT_EXPIRE
		KEYWORD NOPROMPT_EXPIRE
		KEYWORD DEFAULT_EXPIRE, SYNTAX=SET_DEFAULT_EXPIRE
		KEYWORD STRIP
		KEYWORD NOSTRIP
		KEYWORD DIGEST
		KEYWORD NODIGEST
		KEYWORD CONTINUOUS_BRIEF
		KEYWORD NOCONTINUOUS_BRIEF
		KEYWORD ALWAYS
		KEYWORD NOALWAYS
	DEFINE SYNTAX SET_NODE
		PARAMETER P1, LABEL=SET_PARAM1, PROMPT="What"
			VALUE(REQUIRED, TYPE=SET_OPTIONS)
		PARAMETER P2, LABEL=NODENAME, VALUE(REQUIRED)
		PARAMETER P3, LABEL=REMOTENAME
		QUALIFIER FOLDER, VALUE(REQUIRED)
	DEFINE SYNTAX SET_NONODE
		QUALIFIER FOLDER, VALUE(REQUIRED)
	DEFINE SYNTAX SET_EXPIRE
		PARAMETER P1, LABEL=SET_PARAM1, PROMPT="What"
			VALUE(REQUIRED, TYPE=SET_OPTIONS)
		PARAMETER P2, LABEL=EXPIRATION, VALUE(TYPE=$NUMBER,REQUIRED)
	DEFINE SYNTAX SET_GENERIC
		PARAMETER P1, LABEL=SET_PARAM1, PROMPT="What"
			VALUE(REQUIRED, TYPE=SET_OPTIONS)
		PARAMETER P2, LABEL=USERNAME, VALUE(REQUIRED)
		QUALIFIER DAYS,VALUE(TYPE=$NUMBER,DEFAULT="7"),DEFAULT
	DEFINE SYNTAX SET_LOGIN
		PARAMETER P1, LABEL=SET_PARAM1, PROMPT="What"
			VALUE(REQUIRED, TYPE=SET_OPTIONS)
		PARAMETER P2, LABEL=USERNAME, VALUE(REQUIRED)
	DEFINE SYNTAX SET_FLAGS
		PARAMETER P1, LABEL=SET_PARAM1, PROMPT="What"
			VALUE(REQUIRED, TYPE=SET_OPTIONS)
		QUALIFIER DEFAULT, NONNEGATABLE
		QUALIFIER ALL, NONNEGATABLE
		QUALIFIER PERMANENT
		QUALIFIER NOPERMANENT
		QUALIFIER FOLDER, VALUE(REQUIRED)
	DEFINE SYNTAX SET_NOFLAGS
		PARAMETER P1, LABEL=SET_PARAM1, PROMPT="What"
			VALUE(REQUIRED, TYPE=SET_OPTIONS)
		QUALIFIER DEFAULT, NONNEGATABLE
		QUALIFIER PERMANENT
		QUALIFIER NOPERMANENT
		QUALIFIER ALL, NONNEGATABLE
		QUALIFIER FOLDER, VALUE(REQUIRED)
	DEFINE SYNTAX SET_BBOARD
		PARAMETER P1, LABEL=SET_PARAM1, PROMPT="What"
			VALUE(REQUIRED, TYPE=SET_OPTIONS)
		PARAMETER P2, LABEL=BB_USERNAME
		QUALIFIER EXPIRATION, VALUE(TYPE=$NUMBER)
			LABEL=EXPIRATION, DEFAULT
		QUALIFIER SPECIAL, NONNEGATABLE
		QUALIFIER VMSMAIL, NONNEGATABLE
		DISALLOW VMSMAIL AND NOT SPECIAL
		DISALLOW VMSMAIL AND NOT BB_USERNAME
	DEFINE SYNTAX SET_FOLDER
		PARAMETER P1, LABEL=SET_PARAM1, PROMPT="What"
			VALUE(REQUIRED, TYPE=SET_OPTIONS)
		PARAMETER P2, LABEL=SELECT_FOLDER
		QUALIFIER MARKED, NONNEGATABLE
		QUALIFIER UNMARKED, NONNEGATABLE
		QUALIFIER SEEN, NONNEGATABLE
		QUALIFIER UNSEEN, NONNEGATABLE
		DISALLOW (MARKED AND SEEN) OR (MARKED AND UNSEEN) OR
			 (UNMARKED AND SEEN) OR (UNMARKED AND UNSEEN)
	DEFINE SYNTAX SET_NOACCESS
		PARAMETER P1, LABEL=SET_PARAM1, PROMPT="What"
			VALUE(REQUIRED, TYPE=SET_OPTIONS)
		PARAMETER P2, LABEL=ACCESS_ID, VALUE(LIST)
		PARAMETER P3, LABEL=ACCESS_FOLDER
		QUALIFIER ALL, NONNEGATABLE
		QUALIFIER READONLY, NONNEGATABLE
		DISALLOW NOT ALL AND NOT ACCESS_ID
		DISALLOW ALL AND NOT READONLY
	DEFINE SYNTAX SET_ACCESS
		PARAMETER P1, LABEL=SET_PARAM1, PROMPT="What"
			VALUE(REQUIRED, TYPE=SET_OPTIONS)
		PARAMETER P2, LABEL=ACCESS_ID, VALUE(LIST)
		PARAMETER P3, LABEL=ACCESS_FOLDER
		QUALIFIER READONLY, NONNEGATABLE
		QUALIFIER ALL, NONNEGATABLE
		DISALLOW NOT ALL AND NOT ACCESS_ID
	DEFINE SYNTAX SET_PRIVILEGES
		PARAMETER P1, LABEL=SET_PARAM1, PROMPT="What"
			VALUE(REQUIRED, TYPE=SET_OPTIONS)
		PARAMETER P2, LABEL=PRIVILEGES, PROMPT="Privileges"
		VALUE (REQUIRED,LIST)
	DEFINE SYNTAX SET_DEFAULT_EXPIRE
		PARAMETER P1, LABEL=SET_PARAM1, PROMPT="What"
			VALUE(REQUIRED, TYPE=SET_OPTIONS)
		PARAMETER P2, LABEL=DEFAULT_EXPIRE, VALUE(TYPE=$NUMBER,REQUIRED)
	DEFINE VERB SHOW
		PARAMETER P1, LABEL=SHOW_PARAM1, PROMPT="What"
			VALUE(REQUIRED, TYPE=SHOW_OPTIONS)
!
! The following are defined to allow qualifiers to be specified
! directly after the SHOW command, i.e. SHOW/FULL FOLDER.
! Otherwise, the CLI routines will reject the command, because it
! first attempts to process the qualifier before process the parameter,
! so it has no information the qualifiers are valid.
!
		QUALIFIER FULL, SYNTAX=SHOW_FOLDER_FULL, NONNEGATABLE
		QUALIFIER ALL, SYNTAX=SHOW_USER
		QUALIFIER FOLDER, VALUE, SYNTAX=SHOW_USER
		QUALIFIER LOGIN, SYNTAX=SHOW_USER
		QUALIFIER NOLOGIN, SYNTAX=SHOW_USER
		QUALIFIER PRINT, SYNTAX=SHOW_KEYPAD_PRINT
		QUALIFIER SINCE, VALUE(TYPE=$DATETIME), SYNTAX=SHOW_USER
		QUALIFIER START, SYNTAX=SHOW_USER
	DEFINE TYPE SHOW_OPTIONS
		KEYWORD FOLDER, SYNTAX=SHOW_FOLDER
		KEYWORD NEW, SYNTAX=SHOW_FLAGS
		KEYWORD PRIVILEGES, SYNTAX=SHOW_FLAGS
		KEYWORD FLAGS, SYNTAX=SHOW_FLAGS
		KEYWORD KEYPAD, SYNTAX=SHOW_KEYPAD
		KEYWORD USER, SYNTAX=SHOW_USER
		KEYWORD VERSION
	DEFINE SYNTAX SHOW_FLAGS
		PARAMETER P1, LABEL=SHOW_PARAM1, PROMPT="What"
			VALUE(REQUIRED, TYPE=SHOW_OPTIONS)
	DEFINE SYNTAX SHOW_KEYPAD
		PARAMETER P1, LABEL=SHOW_PARAM1, PROMPT="What"
			VALUE(REQUIRED, TYPE=SHOW_OPTIONS)
		QUALIFIER PRINT
	DEFINE SYNTAX SHOW_KEYPAD_PRINT
		PARAMETER P1, LABEL=SHOW_PARAM1, PROMPT="What"
			VALUE(REQUIRED, TYPE=SHOW_OPTIONS)
		QUALIFIER PRINT,DEFAULT
	DEFINE SYNTAX SHOW_FOLDER
		PARAMETER P1, LABEL=SHOW_PARAM1, PROMPT="What"
			VALUE(REQUIRED, TYPE=SHOW_OPTIONS)
		PARAMETER P2, LABEL=SHOW_FOLDER
	DEFINE SYNTAX SHOW_USER
		PARAMETER P1, LABEL=SHOW_PARAM1, PROMPT="What"
			VALUE(REQUIRED, TYPE=SHOW_OPTIONS)
		PARAMETER P2, LABEL=USERNAME
		QUALIFIER ALL
		QUALIFIER FOLDER, VALUE
		QUALIFIER LOGIN
		QUALIFIER NOLOGIN
		QUALIFIER SINCE, VALUE(TYPE=$DATETIME)
		QUALIFIER START, VALUE
		DISALLOW (NOLOGIN OR LOGIN OR ALL) AND USERNAME
		DISALLOW (LOGIN AND NOLOGIN)
		DISALLOW (LOGIN OR NOLOGIN) AND FOLDER
	DEFINE SYNTAX SHOW_FOLDER_FULL
		QUALIFIER FULL, DEFAULT
		PARAMETER P1, LABEL=SHOW_PARAM1, PROMPT="What"
			VALUE(REQUIRED, TYPE=SHOW_OPTIONS)
		PARAMETER P2, LABEL=SHOW_FOLDER
	DEFINE VERB SUBSCRIBE
        DEFINE VERB SPAWN
		PARAMETER P1, LABEL=COMMAND, VALUE(TYPE=$REST_OF_LINE)
	DEFINE VERB UNMARK
		PARAMETER P1, LABEL=NUMBER, VALUE(TYPE=$FILE,LIST)
	DEFINE VERB UNDELETE
		PARAMETER P1, LABEL=BULLETIN_NUMBER, VALUE(TYPE=$FILE)
	DEFINE VERB UNSEEN
		PARAMETER P1, LABEL=NUMBER, VALUE(TYPE=$FILE,LIST)
	DEFINE VERB UNSUBSCRIBE
$eod 
$copy/log sys$input BULLETIN.CLD
$deck
!
!  This file is the CLD file used to define a command to execute
!  BULLETIN by using CDU, which adds the command  to the command table.
!  The alternative is to define a symbol to execute BULLETIN.
!  Either way will work, and it is up to the user's to decide which
!  method to work.  (If you don't know which, you probably should use
!  the default symbol method.)
!
 
Define Verb BULLETIN
  Image BULL_DIR:BULLETIN
  Parameter P1, Label = SELECT_FOLDER
  Qualifier ALL
  Qualifier BBOARD
  Qualifier BULLCP
  Qualifier CLEANUP, Value (Required)
  Qualifier EDIT
  Qualifier KEYPAD, Default
  Qualifier LOGIN
  Qualifier MARKED
  Qualifier PAGE, Default
  Qualifier PGFLQUOTA, Value (Type = $NUMBER, Required)
  Qualifier PROMPT, Value (Default = "BULLETIN"), Default
  Qualifier READNEW
  Qualifier REVERSE
  !
  ! The following line causes a line to be outputted separating system notices.
  ! The line consists of a line of all "-"s, i.e.:
  !--------------------------------------------------------------------------
  ! If you want a different character to be used, simply put in the desired one
  ! in the following line.  If you want to disable the feature, remove the
  ! Default at the end of the line.  (Don't remove the whole line!)
  !
  Qualifier SEPARATE, Value (Default = "-"), Default
  Qualifier SEEN
  Qualifier STARTUP
  Qualifier STOP
  Qualifier SYSTEM, Value (Type = $NUMBER, Default = "7")
  Qualifier UNMARKED
  Qualifier UNSEEN
  Qualifier WIDTH, Value (Type = $NUMBER, Required)
  Qualifier WSEXTENT, Value (Type = $NUMBER, Required)
  Disallow (WSEXTENT Or PGFLQUOTA) And Not STARTUP
$eod 
$copy/log sys$input BULLETIN.COM
$deck
$ DEFINE SYS$INPUT SYS$NET
$ BULLETIN
$eod 
$copy/log sys$input BULLMAIN.CLD
$deck
	MODULE BULLETIN_MAINCOMMANDS
	DEFINE VERB BULLETIN
		PARAMETER P1, LABEL=SELECT_FOLDER
		QUALIFIER ALL
		QUALIFIER BBOARD
		QUALIFIER BULLCP
		QUALIFIER CLEANUP, LABEL=CLEANUP, VALUE(REQUIRED)
		QUALIFIER EDIT
		QUALIFIER KEYPAD, DEFAULT
		QUALIFIER LOGIN
		QUALIFIER MARKED
		QUALIFIER PAGE, DEFAULT
		QUALIFIER PGFLQUOTA, VALUE(TYPE=$NUMBER, REQUIRED)
		QUALIFIER READNEW
		QUALIFIER REVERSE
!
! The following line causes a line to be outputted separating system notices.
! The line consists of a line of all "-"s, i.e.:
!--------------------------------------------------------------------------
! If you want a different character to be used, simply put in the desired one
! in the following line.  If you want to disable the feature, remove the
! DEFAULT at the end of the line.  (Don't remove the whole line!)
!
		QUALIFIER SEEN
		QUALIFIER SEPARATE, VALUE(DEFAULT="-"), DEFAULT
		QUALIFIER STARTUP
		QUALIFIER STOP
		QUALIFIER SYSTEM, VALUE(TYPE=$NUMBER, DEFAULT="7")
		QUALIFIER UNSEEN
		QUALIFIER UNMARKED
		QUALIFIER WIDTH, VALUE(TYPE=$NUMBER, REQUIRED)
		QUALIFIER WSEXTENT, VALUE(TYPE=$NUMBER, REQUIRED)
		DISALLOW (WSEXTENT OR PGFLQUOTA) AND NOT STARTUP
$eod 
$copy/log sys$input BULLSTART.COM
$deck
$ RUN SYS$SYSTEM:INSTALL
BULL_DIR:BULLETIN/SHAR/OPEN/HEAD/-
PRIV=(OPER,SYSPRV,CMKRNL,WORLD,DETACH,PRMMBX,SYSNAM)
/EXIT
$ BULL*ETIN :== $BULL_DIR:BULLETIN
$ BULLETIN/STARTUP
$eod 
$copy/log sys$input BULL_NEWSDUMMY.FOR
$deck
	INTEGER FUNCTION NEWS_ASSIGN()
 
	NEWS_ASSIGN = 0
 
	RETURN
	END
 
	INTEGER FUNCTION NEWS_GET_CHAN(I)
 
	RETURN
	END
 
 
	SUBROUTINE NEWS_SET_CHAN(I)
 
	RETURN
	END
 
	INTEGER FUNCTION NEWS_SOCKET_BULLCP(I,J,K,L)
 
	RETURN
	END
 
 
	INTEGER FUNCTION NEWS_CREATE_BULLCP(I,J,K,L)
 
	RETURN
	END
 
 
	INTEGER FUNCTION NEWS_WRITE_PACKET_BULLCP(I,J,K,L,M,N)
 
	RETURN
	END
 
 
	SUBROUTINE NEWS_DISCONNECT
 
	RETURN
	END
 
 
 
	INTEGER FUNCTION NEWS_CONNECT
 
	NEWS_CONNECT = .FALSE.
 
	RETURN
	END
 
 
 
	INTEGER FUNCTION NEWS_WRITE_PACKET(BUF)
 
	CHARACTER*(*) BUF
 
	RETURN
	END
 
 
 
	INTEGER FUNCTION NEWS_READ_PACKET(BUF)
 
	CHARACTER*(*) BUF
 
	RETURN
	END
 
 
 
	INTEGER FUNCTION NEWS_GETHOSTNAME(BUF)
 
	CHARACTER*(*) BUF
 
	RETURN
	END
 
 
 
        INTEGER FUNCTION NEWS_GETHOST()
 
        RETURN
        END
$eod 
$copy/log sys$input CREATE.COM
$deck
$ FORTRAN/EXTEND/CHECK=(NOBOUNDS,OVERFLOW,NOUNDERFLOW)/NOHPO BULLETIN
$ FORTRAN/EXTEND/CHECK=(NOBOUNDS,OVERFLOW,NOUNDERFLOW)/NOHPO BULLETIN0
$ FORTRAN/EXTEND/CHECK=(NOBOUNDS,OVERFLOW,NOUNDERFLOW)/NOHPO BULLETIN1
$ FORTRAN/EXTEND/CHECK=(NOBOUNDS,OVERFLOW,NOUNDERFLOW)/NOHPO BULLETIN2
$ FORTRAN/EXTEND/CHECK=(NOBOUNDS,OVERFLOW,NOUNDERFLOW)/NOHPO BULLETIN3
$ FORTRAN/EXTEND/CHECK=(NOBOUNDS,OVERFLOW,NOUNDERFLOW)/NOHPO BULLETIN4
$ FORTRAN/EXTEND/CHECK=(NOBOUNDS,OVERFLOW,NOUNDERFLOW)/NOHPO BULLETIN5
$ FORTRAN/EXTEND/CHECK=(NOBOUNDS,OVERFLOW,NOUNDERFLOW)/NOHPO BULLETIN6
$ FORTRAN/EXTEND/CHECK=(NOBOUNDS,OVERFLOW,NOUNDERFLOW)/NOHPO BULLETIN7
$ FORTRAN/EXTEND/CHECK=(NOBOUNDS,OVERFLOW,NOUNDERFLOW)/NOHPO BULLETIN8
$ FORTRAN/EXTEND/CHECK=(NOBOUNDS,OVERFLOW,NOUNDERFLOW)/NOHPO BULLETIN9
$ FORTRAN/EXTEND/CHECK=(NOBOUNDS,OVERFLOW,NOUNDERFLOW)/NOHPO BULLETIN10
$ FORTRAN/EXTEND/CHECK=(NOBOUNDS,OVERFLOW,NOUNDERFLOW)/NOHPO BULLETIN11
$ MAC ALLMACS
$ SET COMMAND/OBJ BULLCOM
$ SET COMMAND/OBJ BULLMAIN
$ ON WARNING THEN GOTO DUMMY
$ IF F$TRNLNM("TWG$TCP") .EQS. "" THEN GOTO MULTI
$ DEFINE VAXC$INCLUDE TWG$TCP:[NETDIST.INCLUDE],-
                      TWG$TCP:[NETDIST.INCLUDE.SYS],-
                      TWG$TCP:[NETDIST.INCLUDE.VMS],-
                      TWG$TCP:[NETDIST.INCLUDE.NETINET],-
                      TWG$TCP:[NETDIST.INCLUDE.ARPA],-
                      SYS$LIBRARY
$ CC BULL_NEWS/DEFINE=(TWG=1)
$ GOTO LINK
$MULTI:
$ IF F$TRNLNM("MULTINET_SOCKET_LIBRARY") .EQS. "" THEN GOTO UCX
$ CC BULL_NEWS/DEFINE=(MULTINET=1)
$ GOTO LINK
$UCX:
$ IF F$TRNLNM("UCX$DEVICE") .EQS. "" THEN GOTO CMU
$ CC BULL_NEWS/DEFINE=(UCX=1)
$ GOTO LINK
$CMU:
$ CC BULL_NEWS
$ GOTO LINK
$DUMMY:
$ WRITE SYS$OUTPUT "There is no C compiler available for the NEWS software."
$ WRITE SYS$OUTPUT "BULLETIN will be assembled without that feature."
$ FOR BULL_NEWSDUMMY
$LINK:
$ IF F$SEARCH("BULL_DIR:READ_BOARD.COM") .NES. "" THEN-
  DELETE BULL_DIR:READ_BOARD.COM;*
$ IF F$SEARCH("BULL.OLB") .EQS. "" THEN LIBRARY/CREATE BULL
$ LIBRARY BULL *.OBJ;
$ DELETE *.OBJ;*
$ @BULLETIN.LNK
$eod 
$copy/log sys$input DCLREMOTE.COM
$deck
$! DCL procedure to execute DCL commands passed over Decnet on a remote system.
$! Commands sent by the command procedure REMOTE.COM on the local system are
$! are received by this procedure on the remote node.
$! This procedure is usually a DECNET OBJECT with task name DCLREMOTE and
$! normally resides in the default DECNET account.  To install as an object,
$! enter NCP, and then use the command:
$!		NCP> SET OBJECT DCLREMOTE FILE file-spec NUM 0
$! where file-spec includes the disk, directory, and file name of the file.
$! If DCLREMOTE is not installed as an object, the logical name DCLREMOTE can
$! be defined to point at it.  
$!
$! Alternativley, DCLREMOTE.COM could be placed in the directory of the user's
$! proxy login on the remote system.
$!
$! WARNING: An EXIT command must not be passed as a command to execute at this
$! procedure level or the link will hang.
$!
$ SET NOON
$ N = 0
$AGAIN:
$ N = N + 1
$ IF N .GE. 5 THEN GOTO DONE
$ OPEN/WRITE/READ/ERR=AGAIN NET SYS$NET
$ DEFINE /NOLOG SYS$OUTPUT NET
$ DEFINE /NOLOG SYS$ERROR NET
$NEXT_CMD:
$  READ /ERR=DONE NET COMMAND
$  'COMMAND'
$  WRITE/ERR=DONE SYS$OUTPUT "COMMAND$DONE ''$STATUS'"
$  GOTO NEXT_CMD
$DONE:
$ CLOSE NET
$eod 
$copy/log sys$input INSTALL.COM
$deck
$ COPY BULLETIN.EXE BULL_DIR:
$ RUN SYS$SYSTEM:INSTALL
BULL_DIR:BULLETIN/DEL
BULL_DIR:BULLETIN/SHAR/OPEN/HEAD/-
PRIV=(OPER,SYSPRV,CMKRNL,WORLD,DETACH,PRMMBX,SYSNAM)
/EXIT
$!
$! NOTE: BULLETIN requires a separate help library. If you do not wish
$! the library to be placed in SYS$HELP, modify the following lines and
$! define the logical name BULL_HELP to be the help library directory, i.e.
$!	$ DEFINE/SYSTEM BULL_HELP SYSD$:[NEWDIRECTORY]
$! The above line should be placed in BULLSTART.COM to be executed after
$! every system reboot.
$!
$ IF F$SEARCH("SYS$HELP:BULL.HLB") .NES. "" THEN LIBRARY/DELETE=*/HELP SYS$HELP:BULL
$ IF F$SEARCH("SYS$HELP:BULL.HLB") .EQS. "" THEN LIBRARY/CREATE/HELP SYS$HELP:BULL
$ LIBRARY/HELP SYS$HELP:BULL BULLCOMS1,BULLCOMS2
$ LIBRARY/HELP SYS$HELP:HELPLIB BULLETIN
$eod 
$copy/log sys$input INSTALL_REMOTE.COM
$deck
$!
$! INSTALL_REMOTE.COM
$! VERSION 5/25/88
$!
$! DESCRIPTION:
$! Command procedure to easily install BULLETIN.EXE on several nodes.
$!
$! INPUTS:
$! The following parameters can be added to the command line.  They
$! should be placed on the command line which executes this command
$! procedure, separated by spaces.  I.e. @INSTALL_REMOTE.COM OLD COPY TEST
$!
$! OLD 	- Specifies that the present version of BULLETIN is 1.51 or earlier.
$! COPY - Specifies that the executable is to be copied to the nodes.
$! TEST - Specifies that all the nodes are to be checked to see if they
$!	  are up before beginning the intallation.
$!
$! NOTES:
$! 	***PLEASE READ ALL COMMENTS BEFORE RUNNING THIS***
$! This calls REMOTE.COM which is also included with the installation.
$!
$! DCLREMOTE.COM must be properly installed on all nodes.
$! See comments at the beginning of that file for instructions.
$! Also, you need to have a proxy login with privileges on those nodes.
$! This procedure assumes that the BULLETIN executable on each node is
$! located in the BULL_DIR directory.  The new executable should be copied
$! to that directory before running this procedure, or the COPY option
$! should be used.
$!
$! If the present version of BULLETIN is 1.51 or earlier, it does not have
$! the ability of setting BULL_DISABLE to disable BULLETIN, so you should
$! use the OLD parameter when running this procedure.
$!
$! INSTRUCTIONS FOR SPECIFYING THE NODES AT YOUR SITE:
$! Place the nodes where bulletin is to be reinstalled in variable NODES.
$! Place the nodes where the executable is to be copied to in COPY_NODES.
$! Place nodes where BULLCP is running in BULLCP_NODES.
$!
$ NODES = "ALCVAX,NERUS,ANANSI,MOLVAX,LAURIE,CANDLE,KLYPSO,DOME" +-
",ARVON,LARAN,ORYANA,PALDAR,MOTHRA,TARNA,DARIUS"
$ COPY_NODES = "NERUS,LAURIE,ARVON"
$ BULLCP_NODES = "NERUS,LAURIE,ARVON"
$!
$ NODES = NODES + ","
$ COPY_NODES = COPY_NODES + ","
$ BULLCP_NODES = BULLCP_NODES + ","
$!
$! Check for any parameters passed to the command procedure.
$!
$ PARAMETER = P1 + P2 + P3
$ OLD = 0
$ IF F$LOCATE("OLD",PARAMETER) .NE. F$LENGTH(PARAMETER) THEN OLD = 1
$ TEST = 0
$ IF F$LOCATE("TEST",PARAMETER) .NE. F$LENGTH(PARAMETER) THEN TEST = 1
$ COPYB = 0
$ IF F$LOCATE("COPY",PARAMETER) .NE. F$LENGTH(PARAMETER) THEN COPYB = 1
$!
$! If TEST requested, see if nodes are accessible.
$!
$ IF .NOT. TEST THEN GOTO END_TEST
$BEGIN_TEST:
$ NODES1 = NODES
$TEST:
$ IF F$LEN(NODES1) .EQ. 0 THEN GOTO END_TEST
$ NODE = F$EXTRACT(0,F$LOCATE(",",NODES1),NODES1)
$ NODES1 = NODES1 - NODE - ","
$ @REMOTE 'NODE' END
$ GOTO TEST
$END_TEST:
$!
$! If COPY requested, copy executable to nodes.
$!
$ IF .NOT. COPYB THEN GOTO END_COPY
$COPY:
$ IF F$LEN(COPY_NODES) .EQ. 0 THEN GOTO END_COPY
$ NODE = F$EXTRACT(0,F$LOCATE(",",COPY_NODES),COPY_NODES)
$ COPY_NODES = COPY_NODES - NODE - ","
$ COPY BULLETIN.EXE 'NODE'::BULL_DIR:
$ GOTO COPY
$END_COPY:
$!
$! The procedure now goes to each node and disables bulletin and kills
$! the BULLCP process if present.  NOTE: If version is < 1.51, we assume
$! that BULLCP is running under SYSTEM account.  This is not necessary
$! for older versions where the BULLETIN/STOP command can be used.
$! If BULLCP is not running under the SYSTEM account for version 1.51
$! or less, you will have to kill them manually before running this!
$!
$BEGIN_DISABLE:
$ NODES1 = NODES
$DISABLE:
$ IF F$LEN(NODES1) .EQ. 0 THEN GOTO END_DISABLE
$ NODE = F$EXTRACT(0,F$LOCATE(",",NODES1),NODES1)
$ NODES1 = NODES1 - NODE - ","
$ @REMOTE 'NODE' CONTINUE SET PROC/PRIV=ALL
$ IF F$LOCATE(","+NODE+",",","+BULLCP_NODES) .EQ. -
 F$LENGTH(","+BULLCP_NODES) THEN GOTO SKIP_STOP_BULLCP
$ IF OLD THEN @REMOTE 'NODE' CONTINUE SET UIC [SYSTEM]
$ IF OLD THEN @REMOTE 'NODE' CONTINUE STOP BULLCP
$ IF .NOT. OLD THEN @REMOTE 'NODE' CONTINUE BULLETIN := $BULL_DIR:BULLETIN
$ IF .NOT. OLD THEN @REMOTE 'NODE' CONTINUE BULLETIN/STOP
$SKIP_STOP_BULLCP:
$ @REMOTE 'NODE' CONTINUE INS := $SYS$SYSTEM:INSTALL
$ IF OLD THEN @REMOTE 'NODE' END INS BULL_DIR:BULLETIN/DELETE
$ IF .NOT. OLD THEN @REMOTE 'NODE' END DEF/SYSTEM BULL_DISABLE DISABLE
$ GOTO DISABLE
$END_DISABLE:
$!
$! The procedure now installs the new BULLETIN.
$!
$ NODES1 = NODES
$INSTALL:
$ IF F$LEN(NODES1) .EQ. 0 THEN EXIT
$ NODE = F$EXTRACT(0,F$LOCATE(",",NODES1),NODES1)
$ NODES1 = NODES1 - NODE - ","
$ @REMOTE 'NODE' CONTINUE SET PROC/PRIV=ALL
$ @REMOTE 'NODE' CONTINUE INS := $SYS$SYSTEM:INSTALL
$ @REMOTE 'NODE' CONTINUE BULLETIN := $BULL_DIR:BULLETIN
$ IF OLD THEN @REMOTE 'NODE' CONTINUE INS BULL_DIR:BULLETIN/SHAR-
/OPEN/HEAD/PRIV=(OPER,SYSPRV,CMKRNL,WORLD,DETACH,PRMMBX,SYSNAM)
$ IF .NOT. OLD THEN @REMOTE 'NODE' CONTINUE INS BULL_DIR:BULLETIN/REPLACE
$ IF .NOT. OLD THEN @REMOTE 'NODE' CONTINUE DEASS/SYSTEM BULL_DISABLE
$ IF F$LOCATE(","+NODE+",",","+BULLCP_NODES) .EQ. -
 F$LENGTH(","+BULLCP_NODES) THEN GOTO SKIP_START_BULLCP
$ @REMOTE 'NODE' CONTINUE SET UIC [SYSTEM]
$ @REMOTE 'NODE' CONTINUE BULLETIN := $BULL_DIR:BULLETIN"
$ @REMOTE 'NODE' CONTINUE BULLETIN/START
$SKIP_START_BULLCP:
$ @REMOTE 'NODE' END CONTINUE
$ GOTO INSTALL
$eod 
$copy/log sys$input INSTRUCT.COM
$deck
$ BULLETIN
ADD/PERMANENT/SYSTEM INSTRUCT.TXT
INFO ON HOW TO USE THE BULLETIN UTILITY.
ADD/PERMANENT NONSYSTEM.TXT
INFO ON BEING PROMPTED TO READ NON-SYSTEM BULLETINS.
EXIT
$eod 
$copy/log sys$input LOGIN.COM
$deck
$!
$! The following line defines the BULLETIN command.
$!
$ BULL*ETIN :== $BULL_DIR:BULLETIN
$!
$! Note: The command prompt when executing the utility is named after
$! the executable image.  Thus, as it is presently set up, the prompt
$! will be "BULLETIN>".  DO NOT make the command that executes the
$! image different from the image name, or certain things will break.
$!
$! If you would rather define the BULLETIN command using CDU rather than
$! defining it using a symbol, use the BULLETIN.CLD file to do so.
$!
$! The following line causes new messages to be displayed upon logging in.
$!
$ BULLETIN/LOGIN/REVERSE
$!
$! If you wish bulletins to be displayed starting with
$! the newest rather the oldest, omit the /REVERSE qualifier.
$! Note that for totally new users, only permanent system messages and
$! the first non-system general message is displayed (which, if you ran
$! INSTURCT.COM, would describe what a non-system message is).
$! This is done so as to avoid overwhelming a new user with lots of
$! messages upon logging in for the first time.
$! Users who have DISMAIL enabled in the authorzation table will automatically
$! be set to "NOLOGIN" (see HELP SET NOLOGIN).  If you wish to disable this
$! feature, add /ALL to the /LOGIN command.
$!
$eod 
$copy/log sys$input MAKEFILE.
$deck
# Makefile for BULLETIN
 
Bulletin : Bulletin.Exe Bull.Hlb
 
Bulletin.Exe : Bull.Olb
   Link /NoTrace Bull.Olb/Lib /Inc=Bulletin$Main,Sys$System:Sys.Stb/Sel -
        /NoUserlib /Exe=Bulletin.Exe,Sys$Input/Opt
   ID="V2.07" $
 
Bull.Olb : Bulletin.Obj Bulletin0.Obj Bulletin1.Obj Bulletin2.Obj  \
           Bulletin3.Obj Bulletin4.Obj Bulletin5.Obj Bulletin6.Obj \
           Bulletin7.Obj Bulletin8.Obj Bulletin9.Obj Bulletin10.Obj \
           Bulletin11.Obj Bullcom.Obj Bullmain.Obj Allmacs.Obj
   Library /Create Bull.Olb *.Obj
   Purge /Log *.Obj,*.Exe
 
Bulletin.Obj : Bulletin.For Bullfiles.Inc Bulldir.Inc Bullfolder.Inc \
               Bulluser.Inc Bullnews.Inc
   Fortran /Extend /NoList Bulletin.For
 
Bulletin0.Obj : Bulletin0.For Bulldir.Inc Bulluser.Inc Bullfolder.Inc \
                Bullfiles.Inc Bullnews.Inc
   Fortran /Extend /NoList Bulletin0.For
 
Bulletin1.Obj : Bulletin1.For Bulldir.Inc Bullfolder.Inc Bulluser.Inc \
                Bullfiles.Inc Bullnews.Inc
   Fortran /Extend /NoList Bulletin1.For
 
Bulletin2.Obj : Bulletin2.For Bulldir.Inc Bulluser.Inc Bullfolder.Inc \
                Bullfiles.Inc Bullnews.Inc
   Fortran /Extend /NoList Bulletin2.For
 
Bulletin3.Obj : Bulletin3.For Bulldir.Inc Bullfolder.Inc Bulluser.Inc \
                Bullfiles.Inc Bullnews.Inc
   Fortran /Extend /NoList Bulletin3.For
 
Bulletin4.Obj : Bulletin4.For Bullfolder.Inc Bulluser.Inc Bullfiles.Inc \
                Bulldir.Inc Bullnews.Inc
   Fortran /Extend /NoList Bulletin4.For
 
Bulletin5.Obj : Bulletin5.For Bulldir.Inc Bulluser.Inc Bullfolder.Inc \
                Bullfiles.Inc Bullnews.Inc
   Fortran /Extend /NoList Bulletin5.For
 
Bulletin6.Obj : Bulletin6.For Bulldir.Inc Bulluser.Inc Bullfolder.Inc \
                Bullfiles.Inc Bullnews.Inc
   Fortran /Extend /NoList Bulletin6.For
 
Bulletin7.Obj : Bulletin7.For Bulldir.Inc Bulluser.Inc Bullfolder.Inc \
                Bullfiles.Inc Bullnews.Inc
   Fortran /Extend /NoList Bulletin7.For
 
Bulletin8.Obj : Bulletin8.For Bulldir.Inc Bulluser.Inc Bullfolder.Inc \
                Bullfiles.Inc Bullnews.Inc
   Fortran /Extend /NoList Bulletin8.For
 
Bulletin9.Obj : Bulletin9.For Bulldir.Inc Bulluser.Inc Bullfolder.Inc \
                Bullfiles.Inc Bullnews.Inc
   Fortran /Extend /NoList Bulletin9.For
 
Bulletin10.Obj : Bulletin10.For Bulldir.Inc Bulluser.Inc Bullfolder.Inc \
                Bullfiles.Inc Bullnews.Inc
   Fortran /Extend /NoList Bulletin10.For
 
Bulletin11.Obj : Bulletin11.For Bulldir.Inc Bulluser.Inc Bullfolder.Inc \
                Bullfiles.Inc Bullnews.Inc
   Fortran /Extend /NoList Bulletin11.For
 
Allmacs.Obj : Allmacs.mar
   Macro   /NoList Allmacs.Mar
 
Bullcom.Obj : Bullcom.cld
   Set Command /Obj Bullcom.Cld
 
Bullmain.Obj : Bullmain.cld
   Set Command /Obj Bullmain.Cld
 
Bull.Hlb : Bullcoms1.Hlp Bullcoms2.Hlp
   Library /Create /Help Bull.Hlb Bullcoms1.Hlp, Bullcoms2.Hlp
   Purge Bull.Hlb
*.hlb :
        lib/help/cre $*
$eod 
$copy/log sys$input OPTIMIZE_RMS.COM
$deck
$ SET NOON
$ EXIT_STATUS = 1
$ IF P1 .NES. "" THEN GOTO BATCH
$!
$GET_FILE:
$ INQUIRE P1 "File to be optimized (^Y to quit)"
$!
$ FILENAME = P1
$ SPEC = F$SEARCH(FILENAME)
$!
$GOT_NAME_INTERACTIVE:
$ NAME = F$PARSE(FILENAME,,,"NAME")
$!
$ IF F$FILE_ATTRIBUTE(FILENAME,"ORG") .EQS. "IDX" THEN-
  GOTO INTERACTIVE_CHECK_ADDS
$ WRITE SYS$OUTPUT "File not indexed"
$ GOTO GET_FILE
$INTERACTIVE_CHECK_ADDS:
$ INQUIRE P2 "Number of records to add after initial load"
$ IF P2 .EQS. "" THEN P2 = 0
$!
$ IF P2 .GE. 0 THEN GOTO INTERACTIVE_CHECK_CONVERT
$ WRITE SYS$OUTPUT "Added records must be >= 0 "
$ GOTO GOT_NAME_INTERACTIVE
$!
$INTERACTIVE_CHECK_CONVERT:
$ INQUIRE P3 "Turn OFF Data and Key compression? (N)"
$ INQUIRE P4 "Turn OFF Index compression? (N)"
$!
$ GOTO ADD_OK
$!
$BATCH:
$GOT_NAME:
$ FILENAME = P1
$ SPEC = F$SEARCH(FILENAME)
$!
$ IF SPEC .NES. "" THEN GOTO FILE_EXISTS
$ WRITE SYS$OUTPUT "File does not exist"
$ EXIT_STATUS = %X18292
$ GOTO DONE
$!
$FILE_EXISTS:
$ NAME = F$PARSE(FILENAME,,,"NAME")
$ IF F$FILE_ATTRIBUTE(FILENAME,"ORG") .EQS. "IDX" THEN-
  GOTO TYPE_OK
$ WRITE SYS$OUTPUT "File not indexed"
$ EXIT_STATUS = 1000024
$ GOTO DONE
$!
$TYPE_OK:
$ IF P2 .EQS. "" THEN P2 = 0
$ IF P2 .GE. 0 THEN GOTO ADD_OK
$!
$ WRITE SYS$OUTPUT "Added records must be >= 0 "
$ EXIT_STATUS = %X38060
$ GOTO DONE
$!
$ADD_OK:
$ ADD_RECORDS = P2
$!
$ NUMBER_OF_KEYS == 'F$FILE_ATTRIBUTE(FILENAME,"NOK")
$ TURN_DATA_COMPRESSION_OFF = P3
$ TURN_INDEX_COMPRESSION_OFF = P4
$ FDL_NAME = F$PARSE(".FDL;0",SPEC)
$ TEMP_FILE = "''NAME'_TEMP_TEMP.COM"
$ OPEN/WRITE/ERROR=OPEN_ERROR OUT 'TEMP_FILE
$ WRITE OUT "$ DEFINE/USER SYS$COMMAND SYS$INPUT"
$ WRITE OUT "$ ANALYZE/RMS/FDL/OUT=''FDL_NAME' ''FILENAME'"
$ WRITE OUT "$ DEFINE/USER SYS$COMMAND SYS$INPUT"
$ WRITE OUT "$ DEFINE/USER EDF$$PLAYBACK_INPUT KLUDGE"
$ WRITE OUT "$ EDIT/FDL/SCRIPT=OPTIMIZE/ANALYZE=''FDL_NAME' ''FDL_NAME'"
$ WRITE OUT ""
$ WRITE OUT ""
$ WRITE OUT ""
$ WRITE OUT ""
$ WRITE OUT 'ADD_RECORDS
$ IF ADD_RECORDS .EQ. 0 THEN GOTO SKIP_NON_ZERO
$ WRITE OUT ""
$ WRITE OUT ""
$SKIP_NON_ZERO:
$ WRITE OUT ""
$ IF TURN_INDEX_COMPRESSION_OFF
$ THEN
$  WRITE OUT "IC"
$  WRITE OUT "NO"
$ ENDIF
$ IF TURN_DATA_COMPRESSION_OFF
$ THEN
$  WRITE OUT "RC"
$  WRITE OUT "NO"
$  WRITE OUT "KC"
$  WRITE OUT "NO"
$ ENDIF
$ WRITE OUT "FD"
$ WRITE OUT "Created from OPTIMIZE_RMS.COM, WITH SPACE/BUCKETSIZE for" +-
  " ''A DD_RECORDS' ADDED RECORDS"
$ WRITE OUT ""
$ WRITE OUT ""
$LOOP:
$ IF NUMBER_OF_KEYS .EQ. 1 THEN GOTO CLOSE_FILE
$ WRITE OUT ""
$ WRITE OUT ""
$ WRITE OUT ""
$ IF TURN_INDEX_COMPRESSION_OFF
$ THEN
$  WRITE OUT "IC"
$  WRITE OUT "NO"
$ ENDIF
$ IF TURN_DATA_COMPRESSION_OFF
$ THEN
$  WRITE OUT "KC"
$  WRITE OUT "NO"
$ ENDIF
$ WRITE OUT "FD"
$ WRITE OUT ""
$ WRITE OUT ""
$ NUMBER_OF_KEYS = 'NUMBER_OF_KEYS - 1
$ GOTO LOOP
$!
$CLOSE_FILE:
$ WRITE OUT "E"
$ CLOSE OUT
$!
$ @'TEMP_FILE
$ DELETE 'TEMP_FILE;*
$ WRITE SYS$OUTPUT ""
$ WRITE SYS$OUTPUT "Starting CONVERT of ''FILENAME'"
$ CONVERT /NOSORT /STAT /FDL='FDL_NAME 'FILENAME 'FILENAME
$ WRITE SYS$OUTPUT ""
$ GOTO DONE
$OPEN_ERROR:
$ WRITE SYS$OUTPUT "Unable to open ''TEMP_FILE'"
$DONE:
$ EXIT 'EXIT_STATUS
$eod 
$copy/log sys$input REMOTE.COM
$deck
$! FILE: REMOTE.COM	VERSION 1.3	EDIT 880513 - CAK
$! DCL procedure to execute DCL commands on a remote decnet node.
$! The remote DECNET object DCLREMOTE.COM must be defined as a known type 0 
$! object on the remote node or the file must be in the login directory
$! of the account used on the remote system. Or the logical name DCLREMOTE
$! can be defined to point at the object.
$!
$! Usage: 	REM*OTE :== @SYS$MANAGER:REMOTE [P1] [P2] ...
$!
$! P1 - Node name commands are to be executed on, including any access control.
$!	If no access control is specified then a proxy login is attempted.
$!	The you do not have an account on the remote system then the default
$!	DECNET account is used.
$! P2 -	DCL command to execute on the remote system. Optional.
$! P3-P8 Additional parameters passed to the command (so quotes aren't needed)
$
$ ON WARNING THEN GOTO ERROR
$ ON CONTROL_Y THEN GOTO ERROR
$ COMMAND := 'P2' 'P3' 'P4' 'P5' 'P6' 'P7' 'P8'
$ IF P2 .EQS. "CONTINUE" THEN COMMAND = COMMAND - "CONTINUE"
$ IF P2 .EQS. "END" THEN COMMAND = COMMAND - "END"
$ NEXT_CMD = "NEXT_CMD"
$ IF P2 .NES. "" THEN NEXT_CMD = "DONE"
$ P1 = P1 - "::"
$ 
$ IF F$LOG ("NET") .EQS. "" THEN GOTO OPEN_LINK
$ IF P2 .EQS. "CONTINUE" THEN GOTO NEXT_CMD
$ IF P2 .EQS. "END" THEN GOTO NEXT_CMD
$OPEN_LINK:
$ WRITE SYS$OUTPUT "Establishing DECNET link to node ''P1'..."
$ OPEN/WRITE/READ NET 'P1'::"TASK=DCLREMOTE"
$
$NEXT_CMD:
$ IF P2 .EQS. "" THEN READ /ERR=ERROR/PROMPT="''P1'> " SYS$COMMAND COMMAND
$ IF F$EDIT(F$EXTR(0,1,COMMAND),"UPCASE") .EQS. "E" THEN GOTO DONE
$ WRITE NET COMMAND
$LOOP:
$   READ/ERR=ERROR/TIME_OUT=10 NET LINE
$   IF F$EXTR (0,12,LINE) .EQS. "COMMAND$DONE" THEN GOTO 'NEXT_CMD'
$   WRITE SYS$OUTPUT LINE
$   GOTO LOOP
$DONE:
$ IF P2 .EQS. "CONTINUE" THEN EXIT
$ IF F$LOG ("NET") .NES. "" THEN CLOSE NET
$ EXIT
$ERROR:
$ IF F$LOG ("NET") .NES. "" THEN CLOSE NET
$ STOP
$eod 
$copy/log sys$input SETUSER.MAR
$deck
	.Title	SETUSER
;
;	Program Setuser
;
;	This program will change the username and UIC of the running process
;
;	To assemble:	$ MACRO SETUSER
;			$ LINK SETUSER,SYS$SYSTEM:SYS.STB/SELECT
;
	.LIBRARY	/SYS$LIBRARY:LIB.MLB/
	$PCBDEF				;define PCB offsets
	$JIBDEF				;define JIB offsets
	$UAFDEF				;define user authorization file offsets
INFAB:	$FAB	FAC=GET -		;only gets on input file
		FNM=<SYSUAF> -		;SYSUAF may be defined as logical name
		DNM=<SYS$SYSTEM:.DAT> -	;These are default directory & suffix
		SHR=<PUT,GET,DEL,UPD>	;allow full sharing
INRAB:	$RAB	FAB=INFAB -		;FAB for this RAB
		KBF=COMMLD+8 -		;key value is typed in by user
		KRF=0 -			;primary key
		KSZ=12 -		;username is 12 bytes long
		RAC=KEY -		;key access on this file
		ROP=NLK -		;don't lock read records
		UBF=BUFFER -		;address of buffer for I/O
		USZ=2048		;size of buffer
BUFFER:	.BLKB	2048			;buffer for data
COMMLD:	.ASCID	/            /		;space for typed in username
PROMPTD:.ASCID	/Username: /		;prompt string
COMMLDS:.WORD	0			;space for number of bytes typed in
FAODESC:.LONG	80
	.LONG	FAOBUF
FAOBUF:	.BLKB	80
FAOLEN:	.BLKW	1
	.BLKW	1
FORSTR:	.ASCID	/PID:!XL from:[!OW,!OW] !AD to:[!OW,!OW] !AD/
TT:	.ASCID	/SYS$OUTPUT/
CHANTT:	.WORD	0			;space for terminal channel number
IOSB:	.QUAD	0
OLDUSER:.BLKB	12			;space for old username
OLDUIC:	.BLKL	1			;space for old uic
ERRORB:	JMP	ERROR			;for branch out of range
 
JPIUSER:	.BLKB	12
JPIUSER_LEN:	.BLKL	1
 
	$DEFINI IT			;DEFINE ITEM LIST FOR GETJPI
$DEF	ITL	.BLKW	1		;LENGTH OF OUTPUT BUFFER
$DEF	ITM	.BLKW	1		;ITEM CODE (PROCESS NAME)
$DEF	ITA	.BLKL	1		;ADDR OF OUTPUT BUFFER
$DEF	ITAL	.BLKL	1		;ADDR OF WORD TO RECIEVE BYTES USED
$DEF	ITEND	.BLKL	1		;ZERO LONG WORD TO END LIST
$DEF	ITSIZE				;SIZE NEEDED FOR IT BLOCK
	$DEFEND IT
 
	.ENTRY	START,^M<>		;start of program
	PUSHAW	COMMLDS			;address of word to get read byte count
	PUSHAL	PROMPTD			;address of prompt string descriptor
	PUSHAL	COMMLD			;address of descriptor to get command
	CALLS	#3,G^LIB$GET_FOREIGN	;use run time library to get command
	BLBC	R0,ERRORB		;low bit clear error
	$OPEN	FAB=INFAB		;open file
	BLBC	R0,ERRORB		;low bit clear error
	$CONNECT RAB=INRAB		;connect file
	BLBC	R0,ERRORB		;low bit clear error
	$GET	RAB=INRAB		;read a record
	CMPL	R0,#RMS$_RNF		;record not found?
	BEQL	errorb			;that's all folks
	CMPL	R0,#RMS$_NORMAL		;ok?
	BNEQ	ERRORB			;no so quit
 
	SUBL	#ITSIZE,SP		;GET SPACE FOR ITEM LIST
	MOVL	SP,R2			;POINT TO IT
	MOVW	#12,ITL(R2)		;SET UP ITEM LIST
	MOVW	#JPI$_USERNAME,ITM(R2)
	MOVAB	JPIUSER,ITA(R2)
	MOVAW	JPIUSER_LEN,ITAL(R2)
	CLRL	ITEND(R2)
	$GETJPI_S	ITMLST=(R2)	;GET PROCESS NAME
	ADDL	#ITSIZE,SP		;RESTORE STACK POINTER
 
	MOVL	INRAB+RAB$L_RBF,R7	;put address of read record in R7
	MOVL	UAF$L_UIC(R7),R8	;R8 has UIC we want
	$CMKRNL_S TWEAK			;change mode to kernel to tweak UIC
					;and username
	BLBC	R0,ERROR		;low bit clear error
	ADDL3	#UAF$S_USERNAME,R7,R8
	ADDL3	#UAF$T_USERNAME,R7,R9
	$FAO_S	CTRSTR=FORSTR,-		;format string
		OUTBUF=FAODESC,-	;char descript for formatted output
		OUTLEN=FAOLEN,-		;long word to hold length of output
		P1=R9,-			;PID
		P2=OLDUIC+2,-		;old UIC, group number
		P3=OLDUIC,-		;old UIC, member number
		P4=#12,-		;usernames are 12 bytes
		P5=#OLDUSER,-		;address of old username
		P6=UAF$L_UIC+2(R7),-	;UIC, group number
		P7=UAF$L_UIC(R7),-	;UIC, member number
		P8=R8,-			;usernames are 12 bytes
		P9=R9			;address of username
	BLBC	R0,ERROR		;low bit clear error
	MOVL	FAOLEN,FAODESC
	PUSHAL	FAODESC			;address of descriptor to get command
	CALLS	#1,G^LIB$PUT_OUTPUT	;use run time library to get command
	BLBC	R0,ERROR		;low bit clear error
EXIT:
	$CLOSE	FAB=INFAB -		;close file
		ERR=ERROR
ERROR:	$EXIT_S	R0			;exit with error if any
	.ENTRY	TWEAK,^M<>		;beginning of kernel mode code
	MOVL	@#CTL$GL_PCB,R11	;put address of our PCB in R11
	MOVL	PCB$L_PID(R11),R9	;save PID
	MOVL	PCB$L_UIC(R11),OLDUIC	;save old UIC
	MOVL	R8,PCB$L_UIC(R11)	;change our UIC
	MOVL	PCB$L_JIB(R11),R10	;put address of Job Info Block in R10
					;MOVC blats R0-R5
	MOVC3	#12,JIB$T_USERNAME(R10),OLDUSER ;save old username
	CMPC3	JPIUSER_LEN,JPIUSER,OLDUSER
	BEQL	GOOD
	CLRL	R0
	RET	
GOOD:	MOVC3	#12,UAF$T_USERNAME(R7),JIB$T_USERNAME(R10) ;change username JIB
	MOVC3	#12,UAF$T_USERNAME(R7),CTL$T_USERNAME ;change username in P1
EEXIT:	MOVL	#SS$_NORMAL,R0		;set normal exit status
	RET				;end of exec mode code
	.END	START			;end of program
$eod 
