package repl

import (
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	_ "modernc.org/sqlite" // db engine.

	"git.lyda.ie/pp/bulletin/storage"
)

func TestRepl(t *testing.T) {
	a := assert.New(t)
	r := require.New(t)

	storage.ConfigureTestDB(t)
	defer storage.RemoveTestDB()
	db, err := storage.Open()
	a.NotNil(db)
	a.Nil(err)

	err = commands.ParseAndRun("BADCOMMAND")
	r.NotNil(err)
	a.Equal("Unknown command 'BADCOMMAND'", err.Error(), "Unexpected error.")

	//err = commands.ParseAndRun("INDEX")
	//.Nil(err)
}
