// Code generated by sqlc. DO NOT EDIT.
// versions:
//   sqlc v1.29.0
// source: broadcast.sql

package storage

import (
	"context"
	"time"
)

const createBroadcast = `-- name: CreateBroadcast :exec
INSERT INTO broadcast
    (author, bell, message)
  VALUES
    (?, ?, ?)
`

// CreateBroadcast adds a new broadcast message.
//
//	INSERT INTO broadcast
//	    (author, bell, message)
//	  VALUES
//	    (?, ?, ?)
func (q *Queries) CreateBroadcast(ctx context.Context, author string, bell int64, message string) error {
	_, err := q.db.ExecContext(ctx, createBroadcast, author, bell, message)
	return err
}

const getBroadcasts = `-- name: GetBroadcasts :many
SELECT author, bell, message, create_at FROM broadcast WHERE create_at > ? ORDER BY create_at
`

// GetBroadcasts gets new broadcast messages newer than a passed
// time.Time() value and returns them in create_at order.
//
//	SELECT author, bell, message, create_at FROM broadcast WHERE create_at > ? ORDER BY create_at
func (q *Queries) GetBroadcasts(ctx context.Context, createAt time.Time) ([]Broadcast, error) {
	rows, err := q.db.QueryContext(ctx, getBroadcasts, createAt)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []Broadcast
	for rows.Next() {
		var i Broadcast
		if err := rows.Scan(
			&i.Author,
			&i.Bell,
			&i.Message,
			&i.CreateAt,
		); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const reapBroadcasts = `-- name: ReapBroadcasts :exec
DELETE FROM broadcast WHERE julianday(current_timestamp) - julianday(create_at) > 3
`

// ReapBroadcasts deletes broadcast messages over 3 days old.
//
//	DELETE FROM broadcast WHERE julianday(current_timestamp) - julianday(create_at) > 3
func (q *Queries) ReapBroadcasts(ctx context.Context) error {
	_, err := q.db.ExecContext(ctx, reapBroadcasts)
	return err
}

const updateLastActivity = `-- name: UpdateLastActivity :exec
UPDATE users SET last_activity = ? WHERE login = ?
`

// UpdateLastActivity updates the user's last_activity time.
//
//	UPDATE users SET last_activity = ? WHERE login = ?
func (q *Queries) UpdateLastActivity(ctx context.Context, lastActivity time.Time, login string) error {
	_, err := q.db.ExecContext(ctx, updateLastActivity, lastActivity, login)
	return err
}
