/*
Package storage handles storage for the bulletin system.

Much of this code is generated by [github.com/sqlc-dev/sqlc].

# Transactions with Queries

This is from the sqlc docs, but it's a simple example of how to use
transactions with [Queries] functions.

	func bumpCounter(ctx context.Context, db *sql.DB, queries *tutorial.Queries, id int32) error {
		tx, err := db.Begin()
		if err != nil {
			return err
		}
		defer tx.Rollback()
		qtx := queries.WithTx(tx)
		r, err := qtx.GetRecord(ctx, id)
		if err != nil {
			return err
		}
		if err := qtx.UpdateRecord(ctx, tutorial.UpdateRecordParams{
			ID:      r.ID,
			Counter: r.Counter + 1,
		}); err != nil {
			return err
		}
		return tx.Commit()
	}
*/
package storage
