// Code generated by sqlc. DO NOT EDIT.
// versions:
//   sqlc v1.29.0
// source: folders.sql

package storage

import (
	"context"
	"database/sql"
)

const createFolder = `-- name: CreateFolder :exec
INSERT INTO folders
    (name, always, alert, description, owner, system, expire, visibility)
  VALUES
    (?, ?, ?, ?, ?, ?, ?, ?)
`

type CreateFolderParams struct {
	Name        string
	Always      int64
	Alert       int64
	Description string
	Owner       string
	System      int64
	Expire      int64
	Visibility  int64
}

// CreateFolder creates a new folder.
//
//	INSERT INTO folders
//	    (name, always, alert, description, owner, system, expire, visibility)
//	  VALUES
//	    (?, ?, ?, ?, ?, ?, ?, ?)
func (q *Queries) CreateFolder(ctx context.Context, arg CreateFolderParams) error {
	_, err := q.db.ExecContext(ctx, createFolder,
		arg.Name,
		arg.Always,
		arg.Alert,
		arg.Description,
		arg.Owner,
		arg.System,
		arg.Expire,
		arg.Visibility,
	)
	return err
}

const findFolderExact = `-- name: FindFolderExact :one
SELECT name, "always", alert, description, owner, system, expire, visibility, create_at, update_at FROM folders where name = ?
`

// FindFolderExact finds a folder with an exact match.
//
//	SELECT name, "always", alert, description, owner, system, expire, visibility, create_at, update_at FROM folders where name = ?
func (q *Queries) FindFolderExact(ctx context.Context, name string) (Folder, error) {
	row := q.db.QueryRowContext(ctx, findFolderExact, name)
	var i Folder
	err := row.Scan(
		&i.Name,
		&i.Always,
		&i.Alert,
		&i.Description,
		&i.Owner,
		&i.System,
		&i.Expire,
		&i.Visibility,
		&i.CreateAt,
		&i.UpdateAt,
	)
	return i, err
}

const findFolderPrefix = `-- name: FindFolderPrefix :one
SELECT name, "always", alert, description, owner, system, expire, visibility, create_at, update_at FROM folders where name LIKE ?1 || '%'
ORDER BY name
LIMIT 1
`

// FindFolderPrefix finds a folder based on a prefix.
//
//	SELECT name, "always", alert, description, owner, system, expire, visibility, create_at, update_at FROM folders where name LIKE ?1 || '%'
//	ORDER BY name
//	LIMIT 1
func (q *Queries) FindFolderPrefix(ctx context.Context, name sql.NullString) (Folder, error) {
	row := q.db.QueryRowContext(ctx, findFolderPrefix, name)
	var i Folder
	err := row.Scan(
		&i.Name,
		&i.Always,
		&i.Alert,
		&i.Description,
		&i.Owner,
		&i.System,
		&i.Expire,
		&i.Visibility,
		&i.CreateAt,
		&i.UpdateAt,
	)
	return i, err
}

const getFolderExpire = `-- name: GetFolderExpire :one
SELECT expire FROM folders WHERE name = ?
`

// GetFolderExpire gets the default expiration (in days) for a folder.
//
//	SELECT expire FROM folders WHERE name = ?
func (q *Queries) GetFolderExpire(ctx context.Context, name string) (int64, error) {
	row := q.db.QueryRowContext(ctx, getFolderExpire, name)
	var expire int64
	err := row.Scan(&expire)
	return expire, err
}

const isFolderOwner = `-- name: IsFolderOwner :one
SELECT 1 FROM folders WHERE name = ? AND owner = ?
`

// IsFolderOwner returns true if a user is a folder owner.
//
//	SELECT 1 FROM folders WHERE name = ? AND owner = ?
func (q *Queries) IsFolderOwner(ctx context.Context, name string, owner string) (int64, error) {
	row := q.db.QueryRowContext(ctx, isFolderOwner, name, owner)
	var column_1 int64
	err := row.Scan(&column_1)
	return column_1, err
}

const isFolderReadable = `-- name: IsFolderReadable :one
SELECT 1 FROM folders WHERE name = ? AND (visibility <= 1 OR owner = ?)
`

// IsFolderReadable checks if a folder is readable for a given user.
//
//	SELECT 1 FROM folders WHERE name = ? AND (visibility <= 1 OR owner = ?)
func (q *Queries) IsFolderReadable(ctx context.Context, name string, owner string) (int64, error) {
	row := q.db.QueryRowContext(ctx, isFolderReadable, name, owner)
	var column_1 int64
	err := row.Scan(&column_1)
	return column_1, err
}

const isFolderWriteable = `-- name: IsFolderWriteable :one
SELECT 1 FROM folders WHERE name = ? AND (visibility = 0 OR owner = ?)
`

// IsFolderWriteable checks if a folder is writeable for a given user.
//
//	SELECT 1 FROM folders WHERE name = ? AND (visibility = 0 OR owner = ?)
func (q *Queries) IsFolderWriteable(ctx context.Context, name string, owner string) (int64, error) {
	row := q.db.QueryRowContext(ctx, isFolderWriteable, name, owner)
	var column_1 int64
	err := row.Scan(&column_1)
	return column_1, err
}

const listFolder = `-- name: ListFolder :many
SELECT f.name, count(m.id) as count, f.description
FROM folders AS f LEFT JOIN messages AS m ON f.name = m.folder
GROUP By f.name
ORDER BY f.name
`

type ListFolderRow struct {
	Name        string
	Count       int64
	Description string
}

// ListFolder lists folders and their message counts.
//
//	SELECT f.name, count(m.id) as count, f.description
//	FROM folders AS f LEFT JOIN messages AS m ON f.name = m.folder
//	GROUP By f.name
//	ORDER BY f.name
func (q *Queries) ListFolder(ctx context.Context) ([]ListFolderRow, error) {
	rows, err := q.db.QueryContext(ctx, listFolder)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []ListFolderRow
	for rows.Next() {
		var i ListFolderRow
		if err := rows.Scan(&i.Name, &i.Count, &i.Description); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const updateFolderAlert = `-- name: UpdateFolderAlert :exec
UPDATE folders SET alert = ? WHERE name = ?
`

// UpdateFolderAlert updates the alert setting for a folder.
//
//	UPDATE folders SET alert = ? WHERE name = ?
func (q *Queries) UpdateFolderAlert(ctx context.Context, alert int64, name string) error {
	_, err := q.db.ExecContext(ctx, updateFolderAlert, alert, name)
	return err
}

const updateFolderAlways = `-- name: UpdateFolderAlways :exec
UPDATE folders SET always = ? WHERE name = ?
`

// UpdateFolderAlways updates the always setting for a folder.
//
//	UPDATE folders SET always = ? WHERE name = ?
func (q *Queries) UpdateFolderAlways(ctx context.Context, always int64, name string) error {
	_, err := q.db.ExecContext(ctx, updateFolderAlways, always, name)
	return err
}

const updateFolderMain = `-- name: UpdateFolderMain :exec
UPDATE folders SET description = ?, owner = ?, name = ?3  WHERE name = ?4
`

type UpdateFolderMainParams struct {
	Description string
	Owner       string
	NewName     string
	OldName     string
}

// UpdateFolderMain updates the description, owner and name of a folder.
//
//	UPDATE folders SET description = ?, owner = ?, name = ?3  WHERE name = ?4
func (q *Queries) UpdateFolderMain(ctx context.Context, arg UpdateFolderMainParams) error {
	_, err := q.db.ExecContext(ctx, updateFolderMain,
		arg.Description,
		arg.Owner,
		arg.NewName,
		arg.OldName,
	)
	return err
}

const updateFolderSystem = `-- name: UpdateFolderSystem :exec
UPDATE folders SET system = ? WHERE name = ?
`

// UpdateFolderSystem updates the system setting for a folder.
//
//	UPDATE folders SET system = ? WHERE name = ?
func (q *Queries) UpdateFolderSystem(ctx context.Context, system int64, name string) error {
	_, err := q.db.ExecContext(ctx, updateFolderSystem, system, name)
	return err
}

const updateFolderVisibility = `-- name: UpdateFolderVisibility :exec
UPDATE folders SET visibility = ? WHERE name = ?
`

// UpdateFolderVisibility updates the visibility setting for a folder.
//
//	UPDATE folders SET visibility = ? WHERE name = ?
func (q *Queries) UpdateFolderVisibility(ctx context.Context, visibility int64, name string) error {
	_, err := q.db.ExecContext(ctx, updateFolderVisibility, visibility, name)
	return err
}
