// Code generated by sqlc. DO NOT EDIT.
// versions:
//   sqlc v1.29.0
// source: messages.sql

package storage

import (
	"context"
	"database/sql"
	"time"
)

const createMessage = `-- name: CreateMessage :exec
INSERT INTO messages (
  id, folder, author, subject, message, permanent, shutdown, expiration
) VALUES (
  (SELECT COALESCE(MAX(id), 0) + 1 FROM messages AS m WHERE m.folder = ?1),
  ?1, ?2, ?3, ?4, ?5, ?6, ?7)
`

type CreateMessageParams struct {
	Folder     string
	Author     string
	Subject    string
	Message    string
	Permanent  int64
	Shutdown   int64
	Expiration time.Time
}

// CreateMessage creates a new message.
//
//	INSERT INTO messages (
//	  id, folder, author, subject, message, permanent, shutdown, expiration
//	) VALUES (
//	  (SELECT COALESCE(MAX(id), 0) + 1 FROM messages AS m WHERE m.folder = ?1),
//	  ?1, ?2, ?3, ?4, ?5, ?6, ?7)
func (q *Queries) CreateMessage(ctx context.Context, arg CreateMessageParams) error {
	_, err := q.db.ExecContext(ctx, createMessage,
		arg.Folder,
		arg.Author,
		arg.Subject,
		arg.Message,
		arg.Permanent,
		arg.Shutdown,
		arg.Expiration,
	)
	return err
}

const deleteAllMessages = `-- name: DeleteAllMessages :exec
DELETE FROM messages WHERE folder = ?
`

// DeleteAllMessages delete all messages in a folder.
//
//	DELETE FROM messages WHERE folder = ?
func (q *Queries) DeleteAllMessages(ctx context.Context, folder string) error {
	_, err := q.db.ExecContext(ctx, deleteAllMessages, folder)
	return err
}

const getAlertMessages = `-- name: GetAlertMessages :many
SELECT CAST(f.alert AS INT) AS folder_alert,
       CAST(COALESCE(fc.alert, 0) AS INT) AS user_alert,
       m.id, m.folder, m.author, m.subject, m.message, m.permanent, m.system, m.shutdown, m.expiration, m.create_at, m.update_at
  FROM messages AS m
  LEFT OUTER JOIN folders AS f ON m.folder = f.name
  LEFT OUTER JOIN folder_configs AS fc ON f.name = fc.folder AND fc.login = ?
  WHERE m.create_at >= ?
    AND (f.alert > 4 OR fc.alert > 1
         OR (f.alert > 1 AND COALESCE(fc.alert, 0) != 1))
  ORDER BY m.folder, m.id
`

type GetAlertMessagesRow struct {
	FolderAlert int64
	UserAlert   int64
	Message     Message
}

// GetAlertMessages get all alert messages for a user older than a
// certain date that are brief, readnew, or shownew.
//
//	SELECT CAST(f.alert AS INT) AS folder_alert,
//	       CAST(COALESCE(fc.alert, 0) AS INT) AS user_alert,
//	       m.id, m.folder, m.author, m.subject, m.message, m.permanent, m.system, m.shutdown, m.expiration, m.create_at, m.update_at
//	  FROM messages AS m
//	  LEFT OUTER JOIN folders AS f ON m.folder = f.name
//	  LEFT OUTER JOIN folder_configs AS fc ON f.name = fc.folder AND fc.login = ?
//	  WHERE m.create_at >= ?
//	    AND (f.alert > 4 OR fc.alert > 1
//	         OR (f.alert > 1 AND COALESCE(fc.alert, 0) != 1))
//	  ORDER BY m.folder, m.id
func (q *Queries) GetAlertMessages(ctx context.Context, login string, createAt time.Time) ([]GetAlertMessagesRow, error) {
	rows, err := q.db.QueryContext(ctx, getAlertMessages, login, createAt)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []GetAlertMessagesRow
	for rows.Next() {
		var i GetAlertMessagesRow
		if err := rows.Scan(
			&i.FolderAlert,
			&i.UserAlert,
			&i.Message.ID,
			&i.Message.Folder,
			&i.Message.Author,
			&i.Message.Subject,
			&i.Message.Message,
			&i.Message.Permanent,
			&i.Message.System,
			&i.Message.Shutdown,
			&i.Message.Expiration,
			&i.Message.CreateAt,
			&i.Message.UpdateAt,
		); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const getLastRead = `-- name: GetLastRead :many
SELECT CAST(MAX(m.id) AS INT) AS id, m.author FROM messages AS m, users AS u
  WHERE folder = ? AND u.login == m.author
  GROUP BY m.author
  ORDER BY m.author
`

type GetLastReadRow struct {
	ID     int64
	Author string
}

// GetLastRead gets the last message read by a login in a folder.
//
//	SELECT CAST(MAX(m.id) AS INT) AS id, m.author FROM messages AS m, users AS u
//	  WHERE folder = ? AND u.login == m.author
//	  GROUP BY m.author
//	  ORDER BY m.author
func (q *Queries) GetLastRead(ctx context.Context, folder string) ([]GetLastReadRow, error) {
	rows, err := q.db.QueryContext(ctx, getLastRead, folder)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []GetLastReadRow
	for rows.Next() {
		var i GetLastReadRow
		if err := rows.Scan(&i.ID, &i.Author); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const getLastReadByEnabled = `-- name: GetLastReadByEnabled :many
SELECT CAST(MAX(m.id) AS INT) AS id, m.author FROM messages AS m, users AS u
  WHERE folder = ? AND u.login == m.author AND u.disabled = ?
  GROUP BY m.author
  ORDER BY m.author
`

type GetLastReadByEnabledRow struct {
	ID     int64
	Author string
}

// GetLastReadByEnabled gets the last message for a user that's enabled.
//
//	SELECT CAST(MAX(m.id) AS INT) AS id, m.author FROM messages AS m, users AS u
//	  WHERE folder = ? AND u.login == m.author AND u.disabled = ?
//	  GROUP BY m.author
//	  ORDER BY m.author
func (q *Queries) GetLastReadByEnabled(ctx context.Context, folder string, disabled int64) ([]GetLastReadByEnabledRow, error) {
	rows, err := q.db.QueryContext(ctx, getLastReadByEnabled, folder, disabled)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []GetLastReadByEnabledRow
	for rows.Next() {
		var i GetLastReadByEnabledRow
		if err := rows.Scan(&i.ID, &i.Author); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const getLastReadByUser = `-- name: GetLastReadByUser :one
SELECT CAST(MAX(m.id) AS INT) AS id, m.author FROM messages AS m, users AS u
  WHERE folder = ? AND u.login == m.author AND m.author = ?
`

type GetLastReadByUserRow struct {
	ID     int64
	Author string
}

// GetLastReadByUser get last message read by a user in a folder.
//
//	SELECT CAST(MAX(m.id) AS INT) AS id, m.author FROM messages AS m, users AS u
//	  WHERE folder = ? AND u.login == m.author AND m.author = ?
func (q *Queries) GetLastReadByUser(ctx context.Context, folder string, author string) (GetLastReadByUserRow, error) {
	row := q.db.QueryRowContext(ctx, getLastReadByUser, folder, author)
	var i GetLastReadByUserRow
	err := row.Scan(&i.ID, &i.Author)
	return i, err
}

const lastMsgidIgnoringSeen = `-- name: LastMsgidIgnoringSeen :one
SELECT CAST(MAX(id) AS INT) FROM messages AS m WHERE m.folder = ?1
`

// LastMsgidIgnoringSeen last message id in a folder without factoring in
// if the message has been seen.
//
//	SELECT CAST(MAX(id) AS INT) FROM messages AS m WHERE m.folder = ?1
func (q *Queries) LastMsgidIgnoringSeen(ctx context.Context, folder string) (int64, error) {
	row := q.db.QueryRowContext(ctx, lastMsgidIgnoringSeen, folder)
	var column_1 int64
	err := row.Scan(&column_1)
	return column_1, err
}

const nextMsgid = `-- name: NextMsgid :one
SELECT CAST(COALESCE(MIN(id), 0) AS INT) FROM messages AS m
  WHERE m.folder = ?1 AND m.id > ?2
  AND id NOT IN (SELECT msgid FROM seen AS s WHERE s.folder = ?1 AND s.login = ?3)
`

// NextMsgid gets the next unread message id.
//
//	SELECT CAST(COALESCE(MIN(id), 0) AS INT) FROM messages AS m
//	  WHERE m.folder = ?1 AND m.id > ?2
//	  AND id NOT IN (SELECT msgid FROM seen AS s WHERE s.folder = ?1 AND s.login = ?3)
func (q *Queries) NextMsgid(ctx context.Context, folder string, iD int64, login string) (int64, error) {
	row := q.db.QueryRowContext(ctx, nextMsgid, folder, iD, login)
	var column_1 int64
	err := row.Scan(&column_1)
	return column_1, err
}

const nextMsgidIgnoringSeen = `-- name: NextMsgidIgnoringSeen :one
SELECT CAST(MIN(id) AS INT) FROM messages AS m
  WHERE m.folder = ?1 AND m.id > ?2
`

// NextMsgidIgnoringSeen gets the next message id.
//
//	SELECT CAST(MIN(id) AS INT) FROM messages AS m
//	  WHERE m.folder = ?1 AND m.id > ?2
func (q *Queries) NextMsgidIgnoringSeen(ctx context.Context, folder string, iD int64) (int64, error) {
	row := q.db.QueryRowContext(ctx, nextMsgidIgnoringSeen, folder, iD)
	var column_1 int64
	err := row.Scan(&column_1)
	return column_1, err
}

const prevMsgid = `-- name: PrevMsgid :one
SELECT CAST(COALESCE(MAX(id), 0) AS INT) FROM messages AS m
  WHERE m.folder = ?1 AND m.id < ?2
  AND id NOT IN (SELECT msgid FROM seen AS s WHERE s.folder = ?1 AND s.login = ?3)
`

// PrevMsgid get the previous message id.
//
//	SELECT CAST(COALESCE(MAX(id), 0) AS INT) FROM messages AS m
//	  WHERE m.folder = ?1 AND m.id < ?2
//	  AND id NOT IN (SELECT msgid FROM seen AS s WHERE s.folder = ?1 AND s.login = ?3)
func (q *Queries) PrevMsgid(ctx context.Context, folder string, iD int64, login string) (int64, error) {
	row := q.db.QueryRowContext(ctx, prevMsgid, folder, iD, login)
	var column_1 int64
	err := row.Scan(&column_1)
	return column_1, err
}

const readMessage = `-- name: ReadMessage :one
SELECT id, folder, author, subject, message, permanent, system, shutdown, expiration, create_at, update_at FROM messages WHERE folder = ? AND id = ?
`

// ReadMessage returns a specified message id from a folder.
//
//	SELECT id, folder, author, subject, message, permanent, system, shutdown, expiration, create_at, update_at FROM messages WHERE folder = ? AND id = ?
func (q *Queries) ReadMessage(ctx context.Context, folder string, iD int64) (Message, error) {
	row := q.db.QueryRowContext(ctx, readMessage, folder, iD)
	var i Message
	err := row.Scan(
		&i.ID,
		&i.Folder,
		&i.Author,
		&i.Subject,
		&i.Message,
		&i.Permanent,
		&i.System,
		&i.Shutdown,
		&i.Expiration,
		&i.CreateAt,
		&i.UpdateAt,
	)
	return i, err
}

const search = `-- name: Search :many
SELECT id, folder, author, subject, message, permanent, system, shutdown, expiration, create_at, update_at FROM messages
  WHERE (message LIKE '%' || ?1 || '%'
     OR subject LIKE '%' || ?1 || '%')
    AND id >= ?2
    AND folder = ?3
  ORDER BY id ASC
`

// Search find messages that match subject or message text.
//
//	SELECT id, folder, author, subject, message, permanent, system, shutdown, expiration, create_at, update_at FROM messages
//	  WHERE (message LIKE '%' || ?1 || '%'
//	     OR subject LIKE '%' || ?1 || '%')
//	    AND id >= ?2
//	    AND folder = ?3
//	  ORDER BY id ASC
func (q *Queries) Search(ctx context.Context, column1 sql.NullString, iD int64, folder string) ([]Message, error) {
	rows, err := q.db.QueryContext(ctx, search, column1, iD, folder)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []Message
	for rows.Next() {
		var i Message
		if err := rows.Scan(
			&i.ID,
			&i.Folder,
			&i.Author,
			&i.Subject,
			&i.Message,
			&i.Permanent,
			&i.System,
			&i.Shutdown,
			&i.Expiration,
			&i.CreateAt,
			&i.UpdateAt,
		); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const searchReply = `-- name: SearchReply :many
SELECT id, folder, author, subject, message, permanent, system, shutdown, expiration, create_at, update_at FROM messages
  WHERE message LIKE '%' || ? || '%'
    AND subject = ?
    AND id >= ?
    AND folder = ?
  ORDER BY id ASC
`

type SearchReplyParams struct {
	Column1 sql.NullString
	Subject string
	ID      int64
	Folder  string
}

// SearchReply find messages that match a specific subject and a different
// message text.
//
//	SELECT id, folder, author, subject, message, permanent, system, shutdown, expiration, create_at, update_at FROM messages
//	  WHERE message LIKE '%' || ? || '%'
//	    AND subject = ?
//	    AND id >= ?
//	    AND folder = ?
//	  ORDER BY id ASC
func (q *Queries) SearchReply(ctx context.Context, arg SearchReplyParams) ([]Message, error) {
	rows, err := q.db.QueryContext(ctx, searchReply,
		arg.Column1,
		arg.Subject,
		arg.ID,
		arg.Folder,
	)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []Message
	for rows.Next() {
		var i Message
		if err := rows.Scan(
			&i.ID,
			&i.Folder,
			&i.Author,
			&i.Subject,
			&i.Message,
			&i.Permanent,
			&i.System,
			&i.Shutdown,
			&i.Expiration,
			&i.CreateAt,
			&i.UpdateAt,
		); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const searchReplyReverse = `-- name: SearchReplyReverse :many
SELECT id, folder, author, subject, message, permanent, system, shutdown, expiration, create_at, update_at FROM messages
  WHERE message LIKE '%' || ? || '%'
    AND subject = ?
    AND id <= ?
    AND folder = ?
  ORDER BY DESC
`

type SearchReplyReverseParams struct {
	Column1 sql.NullString
	Subject string
	ID      int64
	Folder  string
}

// SearchReplyReverse find messages that match a specific subject and
// a different  message text in reverse order.
//
//	SELECT id, folder, author, subject, message, permanent, system, shutdown, expiration, create_at, update_at FROM messages
//	  WHERE message LIKE '%' || ? || '%'
//	    AND subject = ?
//	    AND id <= ?
//	    AND folder = ?
//	  ORDER BY DESC
func (q *Queries) SearchReplyReverse(ctx context.Context, arg SearchReplyReverseParams) ([]Message, error) {
	rows, err := q.db.QueryContext(ctx, searchReplyReverse,
		arg.Column1,
		arg.Subject,
		arg.ID,
		arg.Folder,
	)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []Message
	for rows.Next() {
		var i Message
		if err := rows.Scan(
			&i.ID,
			&i.Folder,
			&i.Author,
			&i.Subject,
			&i.Message,
			&i.Permanent,
			&i.System,
			&i.Shutdown,
			&i.Expiration,
			&i.CreateAt,
			&i.UpdateAt,
		); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const searchReverse = `-- name: SearchReverse :many
SELECT id, folder, author, subject, message, permanent, system, shutdown, expiration, create_at, update_at FROM messages
  WHERE (message LIKE '%' || ?1 || '%'
     OR subject LIKE '%' || ?1 || '%')
    AND id <= ?2
    AND folder = ?3
  ORDER BY id DESC
`

// SearchReverse find messages that match subject or message text in reverse order.
//
//	SELECT id, folder, author, subject, message, permanent, system, shutdown, expiration, create_at, update_at FROM messages
//	  WHERE (message LIKE '%' || ?1 || '%'
//	     OR subject LIKE '%' || ?1 || '%')
//	    AND id <= ?2
//	    AND folder = ?3
//	  ORDER BY id DESC
func (q *Queries) SearchReverse(ctx context.Context, column1 sql.NullString, iD int64, folder string) ([]Message, error) {
	rows, err := q.db.QueryContext(ctx, searchReverse, column1, iD, folder)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []Message
	for rows.Next() {
		var i Message
		if err := rows.Scan(
			&i.ID,
			&i.Folder,
			&i.Author,
			&i.Subject,
			&i.Message,
			&i.Permanent,
			&i.System,
			&i.Shutdown,
			&i.Expiration,
			&i.CreateAt,
			&i.UpdateAt,
		); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const searchSubject = `-- name: SearchSubject :many
SELECT id, folder, author, subject, message, permanent, system, shutdown, expiration, create_at, update_at FROM messages
  WHERE subject LIKE '%' || ? || '%'
    AND id >= ?
    AND folder = ?
  ORDER BY id ASC
`

// SearchSubject find messages that match the subject.
//
//	SELECT id, folder, author, subject, message, permanent, system, shutdown, expiration, create_at, update_at FROM messages
//	  WHERE subject LIKE '%' || ? || '%'
//	    AND id >= ?
//	    AND folder = ?
//	  ORDER BY id ASC
func (q *Queries) SearchSubject(ctx context.Context, column1 sql.NullString, iD int64, folder string) ([]Message, error) {
	rows, err := q.db.QueryContext(ctx, searchSubject, column1, iD, folder)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []Message
	for rows.Next() {
		var i Message
		if err := rows.Scan(
			&i.ID,
			&i.Folder,
			&i.Author,
			&i.Subject,
			&i.Message,
			&i.Permanent,
			&i.System,
			&i.Shutdown,
			&i.Expiration,
			&i.CreateAt,
			&i.UpdateAt,
		); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const searchSubjectReverse = `-- name: SearchSubjectReverse :many
SELECT id, folder, author, subject, message, permanent, system, shutdown, expiration, create_at, update_at FROM messages
  WHERE subject LIKE '%' || ? || '%'
    AND id <= ?
    AND folder = ?
  ORDER BY id DESC
`

// SearchSubjectReverse find messages that match the subject in reverse order.
//
//	SELECT id, folder, author, subject, message, permanent, system, shutdown, expiration, create_at, update_at FROM messages
//	  WHERE subject LIKE '%' || ? || '%'
//	    AND id <= ?
//	    AND folder = ?
//	  ORDER BY id DESC
func (q *Queries) SearchSubjectReverse(ctx context.Context, column1 sql.NullString, iD int64, folder string) ([]Message, error) {
	rows, err := q.db.QueryContext(ctx, searchSubjectReverse, column1, iD, folder)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []Message
	for rows.Next() {
		var i Message
		if err := rows.Scan(
			&i.ID,
			&i.Folder,
			&i.Author,
			&i.Subject,
			&i.Message,
			&i.Permanent,
			&i.System,
			&i.Shutdown,
			&i.Expiration,
			&i.CreateAt,
			&i.UpdateAt,
		); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const setMessageSeen = `-- name: SetMessageSeen :exec
INSERT INTO seen (login, folder, msgid) VALUES (?, ?, ?)
`

// SetMessageSeen mark a message as seen for a user.
//
//	INSERT INTO seen (login, folder, msgid) VALUES (?, ?, ?)
func (q *Queries) SetMessageSeen(ctx context.Context, login string, folder string, msgid int64) error {
	_, err := q.db.ExecContext(ctx, setMessageSeen, login, folder, msgid)
	return err
}

const unsetMessageSeen = `-- name: UnsetMessageSeen :exec
DELETE FROM seen WHERE login = ? AND folder = ? AND msgid = ?
`

// UnsetMessageSeen unmark a message as seen for a user.
//
//	DELETE FROM seen WHERE login = ? AND folder = ? AND msgid = ?
func (q *Queries) UnsetMessageSeen(ctx context.Context, login string, folder string, msgid int64) error {
	_, err := q.db.ExecContext(ctx, unsetMessageSeen, login, folder, msgid)
	return err
}

const updateMessage = `-- name: UpdateMessage :exec
UPDATE messages SET
    subject = ?,
    message = ?,
    permanent = ?,
    system = ?,
    shutdown = ?,
    expiration = ?
  WHERE id = ?
`

type UpdateMessageParams struct {
	Subject    string
	Message    string
	Permanent  int64
	System     int64
	Shutdown   int64
	Expiration time.Time
	ID         int64
}

// UpdateMessage updates a message.
//
//	UPDATE messages SET
//	    subject = ?,
//	    message = ?,
//	    permanent = ?,
//	    system = ?,
//	    shutdown = ?,
//	    expiration = ?
//	  WHERE id = ?
func (q *Queries) UpdateMessage(ctx context.Context, arg UpdateMessageParams) error {
	_, err := q.db.ExecContext(ctx, updateMessage,
		arg.Subject,
		arg.Message,
		arg.Permanent,
		arg.System,
		arg.Shutdown,
		arg.Expiration,
		arg.ID,
	)
	return err
}
