-- CreateBroadcast adds a new broadcast message.
-- name: CreateBroadcast :exec
INSERT INTO broadcast
    (author, bell, message)
  VALUES
    (?, ?, ?);

-- GetBroadcasts gets new broadcast messages newer than a passed
-- time.Time() value and returns them in create_at order.
-- name: GetBroadcasts :many
SELECT * FROM broadcast WHERE create_at > ? ORDER BY create_at;

-- UpdateLastActivity updates the user's last_activity time.
-- name: UpdateLastActivity :exec
UPDATE users SET last_activity = ? WHERE login = ?;

-- ReapBroadcasts deletes broadcast messages over 3 days old.
-- name: ReapBroadcasts :exec
DELETE FROM broadcast WHERE julianday(current_timestamp) - julianday(create_at) > 3;
