-- CreateFolder creates a new folder.
-- name: CreateFolder :exec
INSERT INTO folders
    (name, always, alert, description, owner, system, expire, visibility)
  VALUES
    (?, ?, ?, ?, ?, ?, ?, ?);

-- ListFolder lists folders and their message counts.
-- name: ListFolder :many
SELECT f.name, count(m.id) as count, f.description
FROM folders AS f LEFT JOIN messages AS m ON f.name = m.folder
GROUP By f.name
ORDER BY f.name;

-- FindFolderExact finds a folder with an exact match.
-- name: FindFolderExact :one
SELECT * FROM folders where name = ?;

-- FindFolderPrefix finds a folder based on a prefix.
-- name: FindFolderPrefix :one
SELECT * FROM folders where name LIKE sqlc.arg(name) || '%'
ORDER BY name
LIMIT 1;

-- IsFolderReadable checks if a folder is readable for a given user.
-- name: IsFolderReadable :one
SELECT 1 FROM folders WHERE name = ? AND (visibility <= 1 OR owner = ?);

-- IsFolderWriteable checks if a folder is writeable for a given user.
-- name: IsFolderWriteable :one
SELECT 1 FROM folders WHERE name = ? AND (visibility = 0 OR owner = ?);

-- IsFolderOwner returns true if a user is a folder owner.
-- name: IsFolderOwner :one
SELECT 1 FROM folders WHERE name = ? AND owner = ?;

-- GetFolderExpire gets the default expiration (in days) for a folder.
-- name: GetFolderExpire :one
SELECT expire FROM folders WHERE name = ?;

-- UpdateFolderAlways updates the always setting for a folder.
-- name: UpdateFolderAlways :exec
UPDATE folders SET always = ? WHERE name = ?;

-- UpdateFolderSystem updates the system setting for a folder.
-- name: UpdateFolderSystem :exec
UPDATE folders SET system = ? WHERE name = ?;

-- UpdateFolderAlert updates the alert setting for a folder.
-- name: UpdateFolderAlert :exec
UPDATE folders SET alert = ? WHERE name = ?;

-- UpdateFolderVisibility updates the visibility setting for a folder.
-- name: UpdateFolderVisibility :exec
UPDATE folders SET visibility = ? WHERE name = ?;

-- UpdateFolderMain updates the description, owner and name of a folder.
-- name: UpdateFolderMain :exec
UPDATE folders SET description = ?, owner = ?, name = sqlc.arg(new_name)  WHERE name = sqlc.arg(old_name);
