-- ListUsers get a list of all users.
-- name: ListUsers :many
SELECT * FROM users;

-- DeleteUser removes the user (as long as the user isn't SYSTEM).
-- name: DeleteUser :exec
DELETE FROM users WHERE login = ? AND login != 'SYSTEM';

-- GetFolder get a folder by name.
-- name: GetFolder :one
SELECT * FROM folders WHERE name = ?;

-- DeleteFolder remove a folder by name.
-- name: DeleteFolder :exec
DELETE FROM folders WHERE name = ?;

-- ListMessages list all messages in a specific folder.
-- name: ListMessages :many
SELECT * FROM messages WHERE folder = ? ORDER BY id;

-- ListMessageIDs list all message IDs in a specific folder.
-- name: ListMessageIDs :many
SELECT id FROM messages WHERE folder = ? ORDER BY id;

-- GetMessage gets a message by id and by folder.
-- name: GetMessage :one
SELECT * FROM messages WHERE id = ? AND folder = ?;

-- DeleteMessage removes a message by id and by folder.
-- name: DeleteMessage :exec
DELETE FROM messages WHERE id = ? AND folder = ?;

-- AddMark mark a message id for a login in a folder.
-- name: AddMark :exec
INSERT INTO marks (folder, login, msgid) VALUES (?, ?, ?);

-- DeleteMark unmark a message id for a login in a folder.
-- name: DeleteMark :exec
DELETE FROM marks WHERE folder = ? AND login = ? AND msgid = ?;

-- UpdateFolderAccess update folder visibility for a given login and
-- folder.
-- name: UpdateFolderAccess :exec
INSERT INTO folder_access (login, folder, visibility) VALUES (?1, ?2, ?3)
  ON CONFLICT(login, folder) DO UPDATE
  SET visibility = ?3;

-- DeleteFolderAccess remove access for a folder for a given login.
-- name: DeleteFolderAccess :exec
DELETE FROM folder_access WHERE login = ? AND folder = ?;

-- SetSystem sets the system info. The system folder only has a single row.
-- name: SetSystem :exec
INSERT INTO system (rowid, name, default_expire, expire_limit)
            VALUES (1, ?1, ?2, ?3)
  ON CONFLICT(rowid) DO UPDATE
  SET name = ?1, default_expire = ?2, expire_limit = ?3;

-- GetSystem gets the row from the system folder.
-- name: GetSystem :one
SELECT * FROM system LIMIT 1;
