-- GetUser gets the user by login.
-- name: GetUser :one
SELECT * FROM users WHERE login = ?;

-- AddUser adds the user.
-- name: AddUser :one
INSERT INTO users
    (login, name, admin, disabled, last_activity, last_login)
  VALUES
    (?, ?, ?, ?, '1970-01-01', '1970-01-01')
RETURNING *;

-- IsUserAdmin returns the admin setting for the user.
-- name: IsUserAdmin :one
SELECT admin FROM users WHERE login = ?;

-- UpdateUserDisabled updates the disabled setting for the user (excluding
-- the SYSTEM user).
-- name: UpdateUserDisabled :exec
UPDATE users SET disabled = ? WHERE login = ? AND login != 'SYSTEM';

-- UpdateUserAdmin updates the admin setting for the user (excluding
-- the SYSTEM user).
-- name: UpdateUserAdmin :exec
UPDATE users SET admin = ? WHERE login = ? AND login != 'SYSTEM';

-- UpdateUserAlert set user's alert setting for a folder.
-- name: UpdateUserAlert :exec
INSERT INTO folder_configs (login, folder, alert)
  VALUES (?1, ?2, ?3)
  ON CONFLICT(login, folder) DO UPDATE
  SET login = ?1, folder = ?2, alert = ?3;

-- UpdateUserName update user's name for a given login (excluding the
-- SYSTEM user).
-- name: UpdateUserName :exec
UPDATE users SET name = ? WHERE login = ? AND login != 'SYSTEM';

-- UpdateUserMod set user's moderator setting for the user (excluding
-- the SYSTEM user).
-- name: UpdateUserMod :exec
UPDATE users SET moderator = ? WHERE login = ? AND login != 'SYSTEM';

-- UpdateUserPrompt set user's prompt setting for the user (excluding
-- the SYSTEM user).
-- name: UpdateUserPrompt :exec
UPDATE users SET prompt = ? WHERE login = ? AND login != 'SYSTEM';

-- UpdateUserLastLogin set user's last_login time for the user (excluding
-- the SYSTEM user).
-- name: UpdateUserLastLogin :one
UPDATE users SET last_login = CURRENT_TIMESTAMP WHERE login = ? AND login != 'SYSTEM'
RETURNING last_login;

-- GetLastLogin gets the login and last_login time for all users.
-- name: GetLastLogin :many
SELECT login, last_login FROM users ORDER BY login;

-- GetLastLoginByLogin gets the login and last_login time for all users
-- ordered by login.
-- name: GetLastLoginByLogin :one
SELECT login, last_login FROM users WHERE login = ? ORDER BY login;

-- GetLastLoginByEnabled gets the login and last_login time for all users
-- with a given disabled setting ordered by login.
-- name: GetLastLoginByEnabled :many
SELECT login, last_login FROM users WHERE disabled = ? ORDER BY login;
