// Code generated by sqlc. DO NOT EDIT.
// versions:
//   sqlc v1.29.0
// source: standard.sql

package storage

import (
	"context"
)

const addMark = `-- name: AddMark :exec
INSERT INTO marks (folder, login, msgid) VALUES (?, ?, ?)
`

// AddMark mark a message id for a login in a folder.
//
//	INSERT INTO marks (folder, login, msgid) VALUES (?, ?, ?)
func (q *Queries) AddMark(ctx context.Context, folder string, login string, msgid int64) error {
	_, err := q.db.ExecContext(ctx, addMark, folder, login, msgid)
	return err
}

const deleteFolder = `-- name: DeleteFolder :exec
DELETE FROM folders WHERE name = ?
`

// DeleteFolder remove a folder by name.
//
//	DELETE FROM folders WHERE name = ?
func (q *Queries) DeleteFolder(ctx context.Context, name string) error {
	_, err := q.db.ExecContext(ctx, deleteFolder, name)
	return err
}

const deleteFolderAccess = `-- name: DeleteFolderAccess :exec
DELETE FROM folder_access WHERE login = ? AND folder = ?
`

// DeleteFolderAccess remove access for a folder for a given login.
//
//	DELETE FROM folder_access WHERE login = ? AND folder = ?
func (q *Queries) DeleteFolderAccess(ctx context.Context, login string, folder string) error {
	_, err := q.db.ExecContext(ctx, deleteFolderAccess, login, folder)
	return err
}

const deleteMark = `-- name: DeleteMark :exec
DELETE FROM marks WHERE folder = ? AND login = ? AND msgid = ?
`

// DeleteMark unmark a message id for a login in a folder.
//
//	DELETE FROM marks WHERE folder = ? AND login = ? AND msgid = ?
func (q *Queries) DeleteMark(ctx context.Context, folder string, login string, msgid int64) error {
	_, err := q.db.ExecContext(ctx, deleteMark, folder, login, msgid)
	return err
}

const deleteMessage = `-- name: DeleteMessage :exec
DELETE FROM messages WHERE id = ? AND folder = ?
`

// DeleteMessage removes a message by id and by folder.
//
//	DELETE FROM messages WHERE id = ? AND folder = ?
func (q *Queries) DeleteMessage(ctx context.Context, iD int64, folder string) error {
	_, err := q.db.ExecContext(ctx, deleteMessage, iD, folder)
	return err
}

const deleteUser = `-- name: DeleteUser :exec
DELETE FROM users WHERE login = ? AND login != 'SYSTEM'
`

// DeleteUser removes the user (as long as the user isn't SYSTEM).
//
//	DELETE FROM users WHERE login = ? AND login != 'SYSTEM'
func (q *Queries) DeleteUser(ctx context.Context, login string) error {
	_, err := q.db.ExecContext(ctx, deleteUser, login)
	return err
}

const getFolder = `-- name: GetFolder :one
SELECT name, "always", alert, description, owner, system, expire, visibility, create_at, update_at FROM folders WHERE name = ?
`

// GetFolder get a folder by name.
//
//	SELECT name, "always", alert, description, owner, system, expire, visibility, create_at, update_at FROM folders WHERE name = ?
func (q *Queries) GetFolder(ctx context.Context, name string) (Folder, error) {
	row := q.db.QueryRowContext(ctx, getFolder, name)
	var i Folder
	err := row.Scan(
		&i.Name,
		&i.Always,
		&i.Alert,
		&i.Description,
		&i.Owner,
		&i.System,
		&i.Expire,
		&i.Visibility,
		&i.CreateAt,
		&i.UpdateAt,
	)
	return i, err
}

const getMessage = `-- name: GetMessage :one
SELECT id, folder, author, subject, message, permanent, system, shutdown, expiration, create_at, update_at FROM messages WHERE id = ? AND folder = ?
`

// GetMessage gets a message by id and by folder.
//
//	SELECT id, folder, author, subject, message, permanent, system, shutdown, expiration, create_at, update_at FROM messages WHERE id = ? AND folder = ?
func (q *Queries) GetMessage(ctx context.Context, iD int64, folder string) (Message, error) {
	row := q.db.QueryRowContext(ctx, getMessage, iD, folder)
	var i Message
	err := row.Scan(
		&i.ID,
		&i.Folder,
		&i.Author,
		&i.Subject,
		&i.Message,
		&i.Permanent,
		&i.System,
		&i.Shutdown,
		&i.Expiration,
		&i.CreateAt,
		&i.UpdateAt,
	)
	return i, err
}

const getSystem = `-- name: GetSystem :one
SELECT name, default_expire, expire_limit FROM system LIMIT 1
`

// GetSystem gets the row from the system folder.
//
//	SELECT name, default_expire, expire_limit FROM system LIMIT 1
func (q *Queries) GetSystem(ctx context.Context) (System, error) {
	row := q.db.QueryRowContext(ctx, getSystem)
	var i System
	err := row.Scan(&i.Name, &i.DefaultExpire, &i.ExpireLimit)
	return i, err
}

const listMessageIDs = `-- name: ListMessageIDs :many
SELECT id FROM messages WHERE folder = ? ORDER BY id
`

// ListMessageIDs list all message IDs in a specific folder.
//
//	SELECT id FROM messages WHERE folder = ? ORDER BY id
func (q *Queries) ListMessageIDs(ctx context.Context, folder string) ([]int64, error) {
	rows, err := q.db.QueryContext(ctx, listMessageIDs, folder)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []int64
	for rows.Next() {
		var id int64
		if err := rows.Scan(&id); err != nil {
			return nil, err
		}
		items = append(items, id)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const listMessages = `-- name: ListMessages :many
SELECT id, folder, author, subject, message, permanent, system, shutdown, expiration, create_at, update_at FROM messages WHERE folder = ? ORDER BY id
`

// ListMessages list all messages in a specific folder.
//
//	SELECT id, folder, author, subject, message, permanent, system, shutdown, expiration, create_at, update_at FROM messages WHERE folder = ? ORDER BY id
func (q *Queries) ListMessages(ctx context.Context, folder string) ([]Message, error) {
	rows, err := q.db.QueryContext(ctx, listMessages, folder)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []Message
	for rows.Next() {
		var i Message
		if err := rows.Scan(
			&i.ID,
			&i.Folder,
			&i.Author,
			&i.Subject,
			&i.Message,
			&i.Permanent,
			&i.System,
			&i.Shutdown,
			&i.Expiration,
			&i.CreateAt,
			&i.UpdateAt,
		); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const listUsers = `-- name: ListUsers :many
SELECT login, name, admin, moderator, disabled, prompt, signature, last_activity, last_login, create_at, update_at FROM users
`

// ListUsers get a list of all users.
//
//	SELECT login, name, admin, moderator, disabled, prompt, signature, last_activity, last_login, create_at, update_at FROM users
func (q *Queries) ListUsers(ctx context.Context) ([]User, error) {
	rows, err := q.db.QueryContext(ctx, listUsers)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []User
	for rows.Next() {
		var i User
		if err := rows.Scan(
			&i.Login,
			&i.Name,
			&i.Admin,
			&i.Moderator,
			&i.Disabled,
			&i.Prompt,
			&i.Signature,
			&i.LastActivity,
			&i.LastLogin,
			&i.CreateAt,
			&i.UpdateAt,
		); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const setSystem = `-- name: SetSystem :exec
INSERT INTO system (rowid, name, default_expire, expire_limit)
            VALUES (1, ?1, ?2, ?3)
  ON CONFLICT(rowid) DO UPDATE
  SET name = ?1, default_expire = ?2, expire_limit = ?3
`

// SetSystem sets the system info. The system folder only has a single row.
//
//	INSERT INTO system (rowid, name, default_expire, expire_limit)
//	            VALUES (1, ?1, ?2, ?3)
//	  ON CONFLICT(rowid) DO UPDATE
//	  SET name = ?1, default_expire = ?2, expire_limit = ?3
func (q *Queries) SetSystem(ctx context.Context, name string, defaultExpire int64, expireLimit int64) error {
	_, err := q.db.ExecContext(ctx, setSystem, name, defaultExpire, expireLimit)
	return err
}

const updateFolderAccess = `-- name: UpdateFolderAccess :exec
INSERT INTO folder_access (login, folder, visibility) VALUES (?1, ?2, ?3)
  ON CONFLICT(login, folder) DO UPDATE
  SET visibility = ?3
`

// UpdateFolderAccess update folder visibility for a given login and
// folder.
//
//	INSERT INTO folder_access (login, folder, visibility) VALUES (?1, ?2, ?3)
//	  ON CONFLICT(login, folder) DO UPDATE
//	  SET visibility = ?3
func (q *Queries) UpdateFolderAccess(ctx context.Context, login string, folder string, visibility int64) error {
	_, err := q.db.ExecContext(ctx, updateFolderAccess, login, folder, visibility)
	return err
}
