// Code generated by sqlc. DO NOT EDIT.
// versions:
//   sqlc v1.29.0
// source: system.sql

package storage

import (
	"context"
)

const getExpire = `-- name: GetExpire :one
SELECT default_expire, expire_limit FROM system WHERE rowid = 1
`

type GetExpireRow struct {
	DefaultExpire int64
	ExpireLimit   int64
}

// GetExpire get the default expiration value and limit for the system.
//
//	SELECT default_expire, expire_limit FROM system WHERE rowid = 1
func (q *Queries) GetExpire(ctx context.Context) (GetExpireRow, error) {
	row := q.db.QueryRowContext(ctx, getExpire)
	var i GetExpireRow
	err := row.Scan(&i.DefaultExpire, &i.ExpireLimit)
	return i, err
}

const updateDefaultExpire = `-- name: UpdateDefaultExpire :exec
UPDATE system SET default_expire = ? WHERE rowid = 1
`

// UpdateDefaultExpire update the default expiration value for the system.
//
//	UPDATE system SET default_expire = ? WHERE rowid = 1
func (q *Queries) UpdateDefaultExpire(ctx context.Context, defaultExpire int64) error {
	_, err := q.db.ExecContext(ctx, updateDefaultExpire, defaultExpire)
	return err
}

const updateExpireLimit = `-- name: UpdateExpireLimit :exec
UPDATE system SET expire_limit = ? WHERE rowid = 1
`

// UpdateExpireLimit update the default expiration limit for the system.
//
//	UPDATE system SET expire_limit = ? WHERE rowid = 1
func (q *Queries) UpdateExpireLimit(ctx context.Context, expireLimit int64) error {
	_, err := q.db.ExecContext(ctx, updateExpireLimit, expireLimit)
	return err
}
