// Code generated by sqlc. DO NOT EDIT.
// versions:
//   sqlc v1.29.0
// source: users.sql

package storage

import (
	"context"
	"time"
)

const addUser = `-- name: AddUser :one
INSERT INTO users
    (login, name, admin, disabled, last_activity, last_login)
  VALUES
    (?, ?, ?, ?, '1970-01-01', '1970-01-01')
RETURNING login, name, admin, moderator, disabled, prompt, signature, last_activity, last_login, create_at, update_at
`

type AddUserParams struct {
	Login    string
	Name     string
	Admin    int64
	Disabled int64
}

// AddUser adds the user.
//
//	INSERT INTO users
//	    (login, name, admin, disabled, last_activity, last_login)
//	  VALUES
//	    (?, ?, ?, ?, '1970-01-01', '1970-01-01')
//	RETURNING login, name, admin, moderator, disabled, prompt, signature, last_activity, last_login, create_at, update_at
func (q *Queries) AddUser(ctx context.Context, arg AddUserParams) (User, error) {
	row := q.db.QueryRowContext(ctx, addUser,
		arg.Login,
		arg.Name,
		arg.Admin,
		arg.Disabled,
	)
	var i User
	err := row.Scan(
		&i.Login,
		&i.Name,
		&i.Admin,
		&i.Moderator,
		&i.Disabled,
		&i.Prompt,
		&i.Signature,
		&i.LastActivity,
		&i.LastLogin,
		&i.CreateAt,
		&i.UpdateAt,
	)
	return i, err
}

const getLastLogin = `-- name: GetLastLogin :many
SELECT login, last_login FROM users ORDER BY login
`

type GetLastLoginRow struct {
	Login     string
	LastLogin time.Time
}

// GetLastLogin gets the login and last_login time for all users.
//
//	SELECT login, last_login FROM users ORDER BY login
func (q *Queries) GetLastLogin(ctx context.Context) ([]GetLastLoginRow, error) {
	rows, err := q.db.QueryContext(ctx, getLastLogin)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []GetLastLoginRow
	for rows.Next() {
		var i GetLastLoginRow
		if err := rows.Scan(&i.Login, &i.LastLogin); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const getLastLoginByEnabled = `-- name: GetLastLoginByEnabled :many
SELECT login, last_login FROM users WHERE disabled = ? ORDER BY login
`

type GetLastLoginByEnabledRow struct {
	Login     string
	LastLogin time.Time
}

// GetLastLoginByEnabled gets the login and last_login time for all users
// with a given disabled setting ordered by login.
//
//	SELECT login, last_login FROM users WHERE disabled = ? ORDER BY login
func (q *Queries) GetLastLoginByEnabled(ctx context.Context, disabled int64) ([]GetLastLoginByEnabledRow, error) {
	rows, err := q.db.QueryContext(ctx, getLastLoginByEnabled, disabled)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []GetLastLoginByEnabledRow
	for rows.Next() {
		var i GetLastLoginByEnabledRow
		if err := rows.Scan(&i.Login, &i.LastLogin); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const getLastLoginByLogin = `-- name: GetLastLoginByLogin :one
SELECT login, last_login FROM users WHERE login = ? ORDER BY login
`

type GetLastLoginByLoginRow struct {
	Login     string
	LastLogin time.Time
}

// GetLastLoginByLogin gets the login and last_login time for all users
// ordered by login.
//
//	SELECT login, last_login FROM users WHERE login = ? ORDER BY login
func (q *Queries) GetLastLoginByLogin(ctx context.Context, login string) (GetLastLoginByLoginRow, error) {
	row := q.db.QueryRowContext(ctx, getLastLoginByLogin, login)
	var i GetLastLoginByLoginRow
	err := row.Scan(&i.Login, &i.LastLogin)
	return i, err
}

const getUser = `-- name: GetUser :one
SELECT login, name, admin, moderator, disabled, prompt, signature, last_activity, last_login, create_at, update_at FROM users WHERE login = ?
`

// GetUser gets the user by login.
//
//	SELECT login, name, admin, moderator, disabled, prompt, signature, last_activity, last_login, create_at, update_at FROM users WHERE login = ?
func (q *Queries) GetUser(ctx context.Context, login string) (User, error) {
	row := q.db.QueryRowContext(ctx, getUser, login)
	var i User
	err := row.Scan(
		&i.Login,
		&i.Name,
		&i.Admin,
		&i.Moderator,
		&i.Disabled,
		&i.Prompt,
		&i.Signature,
		&i.LastActivity,
		&i.LastLogin,
		&i.CreateAt,
		&i.UpdateAt,
	)
	return i, err
}

const isUserAdmin = `-- name: IsUserAdmin :one
SELECT admin FROM users WHERE login = ?
`

// IsUserAdmin returns the admin setting for the user.
//
//	SELECT admin FROM users WHERE login = ?
func (q *Queries) IsUserAdmin(ctx context.Context, login string) (int64, error) {
	row := q.db.QueryRowContext(ctx, isUserAdmin, login)
	var admin int64
	err := row.Scan(&admin)
	return admin, err
}

const updateUserAdmin = `-- name: UpdateUserAdmin :exec
UPDATE users SET admin = ? WHERE login = ? AND login != 'SYSTEM'
`

// UpdateUserAdmin updates the admin setting for the user (excluding
// the SYSTEM user).
//
//	UPDATE users SET admin = ? WHERE login = ? AND login != 'SYSTEM'
func (q *Queries) UpdateUserAdmin(ctx context.Context, admin int64, login string) error {
	_, err := q.db.ExecContext(ctx, updateUserAdmin, admin, login)
	return err
}

const updateUserAlert = `-- name: UpdateUserAlert :exec
INSERT INTO folder_configs (login, folder, alert)
  VALUES (?1, ?2, ?3)
  ON CONFLICT(login, folder) DO UPDATE
  SET login = ?1, folder = ?2, alert = ?3
`

// UpdateUserAlert set user's alert setting for a folder.
//
//	INSERT INTO folder_configs (login, folder, alert)
//	  VALUES (?1, ?2, ?3)
//	  ON CONFLICT(login, folder) DO UPDATE
//	  SET login = ?1, folder = ?2, alert = ?3
func (q *Queries) UpdateUserAlert(ctx context.Context, login string, folder string, alert int64) error {
	_, err := q.db.ExecContext(ctx, updateUserAlert, login, folder, alert)
	return err
}

const updateUserDisabled = `-- name: UpdateUserDisabled :exec
UPDATE users SET disabled = ? WHERE login = ? AND login != 'SYSTEM'
`

// UpdateUserDisabled updates the disabled setting for the user (excluding
// the SYSTEM user).
//
//	UPDATE users SET disabled = ? WHERE login = ? AND login != 'SYSTEM'
func (q *Queries) UpdateUserDisabled(ctx context.Context, disabled int64, login string) error {
	_, err := q.db.ExecContext(ctx, updateUserDisabled, disabled, login)
	return err
}

const updateUserLastLogin = `-- name: UpdateUserLastLogin :one
UPDATE users SET last_login = CURRENT_TIMESTAMP WHERE login = ? AND login != 'SYSTEM'
RETURNING last_login
`

// UpdateUserLastLogin set user's last_login time for the user (excluding
// the SYSTEM user).
//
//	UPDATE users SET last_login = CURRENT_TIMESTAMP WHERE login = ? AND login != 'SYSTEM'
//	RETURNING last_login
func (q *Queries) UpdateUserLastLogin(ctx context.Context, login string) (time.Time, error) {
	row := q.db.QueryRowContext(ctx, updateUserLastLogin, login)
	var last_login time.Time
	err := row.Scan(&last_login)
	return last_login, err
}

const updateUserMod = `-- name: UpdateUserMod :exec
UPDATE users SET moderator = ? WHERE login = ? AND login != 'SYSTEM'
`

// UpdateUserMod set user's moderator setting for the user (excluding
// the SYSTEM user).
//
//	UPDATE users SET moderator = ? WHERE login = ? AND login != 'SYSTEM'
func (q *Queries) UpdateUserMod(ctx context.Context, moderator int64, login string) error {
	_, err := q.db.ExecContext(ctx, updateUserMod, moderator, login)
	return err
}

const updateUserName = `-- name: UpdateUserName :exec
UPDATE users SET name = ? WHERE login = ? AND login != 'SYSTEM'
`

// UpdateUserName update user's name for a given login (excluding the
// SYSTEM user).
//
//	UPDATE users SET name = ? WHERE login = ? AND login != 'SYSTEM'
func (q *Queries) UpdateUserName(ctx context.Context, name string, login string) error {
	_, err := q.db.ExecContext(ctx, updateUserName, name, login)
	return err
}

const updateUserPrompt = `-- name: UpdateUserPrompt :exec
UPDATE users SET prompt = ? WHERE login = ? AND login != 'SYSTEM'
`

// UpdateUserPrompt set user's prompt setting for the user (excluding
// the SYSTEM user).
//
//	UPDATE users SET prompt = ? WHERE login = ? AND login != 'SYSTEM'
func (q *Queries) UpdateUserPrompt(ctx context.Context, prompt int64, login string) error {
	_, err := q.db.ExecContext(ctx, updateUserPrompt, prompt, login)
	return err
}
