package storage

import (
	"fmt"
	"os"

	"github.com/golang-migrate/migrate/v4"
	"github.com/jmoiron/sqlx"
)

// Skew helps us track database skew.
var Skew SkewChecker

// SkewChecker helps us track database skew.
type SkewChecker struct {
	db     *sqlx.DB
	migver dbVersion
}

// InitialiseSkewChecker creates an object to track skew.
func InitialiseSkewChecker(db *sqlx.DB, m *migrate.Migrate) {
	version, dirty, err := m.Version()
	if err != nil {
		fmt.Printf("ERROR: Schema issue: %s\n", err)
		os.Exit(1)
	}
	Skew = SkewChecker{
		db: db,
		migver: dbVersion{
			Version: version,
			Dirty:   dirty,
		},
	}
}

type dbVersion struct {
	Version uint `db:"version"`
	Dirty   bool `db:"dirty"`
}

// Safe returns true if the DB hasn't skewed.
func (skew *SkewChecker) Safe() bool {
	row := skew.db.QueryRowx("SELECT * FROM schema_migrations")
	v := &dbVersion{
		Dirty: true,
	}
	row.StructScan(v)

	if skew.migver.Version != v.Version {
		return false
	}
	return !v.Dirty
}
